<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineLowestFaresType StructType
 * Meta information extracted from the WSDL
 * - documentation: IntelliSell Type . lowest fare for airline. Currently not used.
 * @subpackage Structs
 */
class AirlineLowestFaresType extends AbstractStructBase
{
    /**
     * The Airline
     * @var \SabreSoap\StructType\CompanyNameType
     */
    public $Airline;
    /**
     * The NoStops
     * @var int
     */
    public $NoStops;
    /**
     * The LowestFare
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $LowestFare;
    /**
     * The ItineraryCount
     * @var mixed
     */
    public $ItineraryCount;
    /**
     * Constructor method for AirlineLowestFaresType
     * @uses AirlineLowestFaresType::setAirline()
     * @uses AirlineLowestFaresType::setNoStops()
     * @uses AirlineLowestFaresType::setLowestFare()
     * @uses AirlineLowestFaresType::setItineraryCount()
     * @param \SabreSoap\StructType\CompanyNameType $airline
     * @param int $noStops
     * @param \SabreSoap\StructType\CurrencyAmountType $lowestFare
     * @param mixed $itineraryCount
     */
    public function __construct(\SabreSoap\StructType\CompanyNameType $airline = null, $noStops = null, \SabreSoap\StructType\CurrencyAmountType $lowestFare = null, $itineraryCount = null)
    {
        $this
            ->setAirline($airline)
            ->setNoStops($noStops)
            ->setLowestFare($lowestFare)
            ->setItineraryCount($itineraryCount);
    }
    /**
     * Get Airline value
     * @return \SabreSoap\StructType\CompanyNameType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \SabreSoap\StructType\CompanyNameType $airline
     * @return \SabreSoap\StructType\AirlineLowestFaresType
     */
    public function setAirline(\SabreSoap\StructType\CompanyNameType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get NoStops value
     * @return int|null
     */
    public function getNoStops()
    {
        return $this->NoStops;
    }
    /**
     * Set NoStops value
     * @param int $noStops
     * @return \SabreSoap\StructType\AirlineLowestFaresType
     */
    public function setNoStops($noStops = null)
    {
        $this->NoStops = $noStops;
        return $this;
    }
    /**
     * Get LowestFare value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getLowestFare()
    {
        return $this->LowestFare;
    }
    /**
     * Set LowestFare value
     * @param \SabreSoap\StructType\CurrencyAmountType $lowestFare
     * @return \SabreSoap\StructType\AirlineLowestFaresType
     */
    public function setLowestFare(\SabreSoap\StructType\CurrencyAmountType $lowestFare = null)
    {
        $this->LowestFare = $lowestFare;
        return $this;
    }
    /**
     * Get ItineraryCount value
     * @return mixed|null
     */
    public function getItineraryCount()
    {
        return $this->ItineraryCount;
    }
    /**
     * Set ItineraryCount value
     * @param mixed $itineraryCount
     * @return \SabreSoap\StructType\AirlineLowestFaresType
     */
    public function setItineraryCount($itineraryCount = null)
    {
        $this->ItineraryCount = $itineraryCount;
        return $this;
    }
}
