<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryPricingInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Pricing Information for an Air Itinerary
 * @subpackage Structs
 */
class AirItineraryPricingInfoType extends AbstractStructBase
{
    /**
     * The ItinTotalFare
     * Meta information extracted from the WSDL
     * - documentation: Total price of the itinerary
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ItinTotalFareType
     */
    public $ItinTotalFare;
    /**
     * The PTC_FareBreakdowns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PTC_FareBreakdowns
     */
    public $PTC_FareBreakdowns;
    /**
     * The FareInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareInfos
     */
    public $FareInfos;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The LastTicketDate
     * Meta information extracted from the WSDL
     * - documentation: Last day to ticket. | Allows for the specification of a date time or just time.
     * - union: string | time
     * @var string
     */
    public $LastTicketDate;
    /**
     * The PrivateFareType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 1
     * @var string
     */
    public $PrivateFareType;
    /**
     * The SpanishFamilyDiscountIndicator
     * @var string
     */
    public $SpanishFamilyDiscountIndicator;
    /**
     * The FlexibleFareID
     * Meta information extracted from the WSDL
     * - documentation: If the fare is an additional flexible fare, this is the fare group ID
     * - use: optional
     * @var int
     */
    public $FlexibleFareID;
    /**
     * The PricingSource
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate whether the pricing is public or private | It can be used to indicate whether the fare is public or private.
     * - base: xs:string
     * - pattern: [0-9A-Z_]{1,13}
     * - type: ResponsePricingSourceType
     * - use: optional
     * @var string
     */
    public $PricingSource;
    /**
     * The PricingSubSource
     * Meta information extracted from the WSDL
     * - documentation: Pricing sub source.
     * - base: xs:string
     * - minLength: 1
     * - pattern: [A-Z_]{1,}
     * - type: PricingSubSourceType
     * - use: optional
     * @var string
     */
    public $PricingSubSource;
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: (MultiPCC) Information about Pseudo City Code for wich the fare was produced.
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The BrandID
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate brand code (e.g. SS for SuperSaver) or type of Fare (e.g. Sale Fare or Full Coach and so on...)
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $BrandID;
    /**
     * The FareReturned
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if a fare returned for the BrandID or not (true if fare is returned and false if no fare returned)
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $FareReturned;
    /**
     * The FareStatus
     * Meta information extracted from the WSDL
     * - documentation: Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable".
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $FareStatus;
    /**
     * The CachedItin
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the itin is from Cache. If true, it is from Cache.
     * - default: false
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $CachedItin;
    /**
     * The CachePartition
     * Meta information extracted from the WSDL
     * - documentation: Indicates source partition of cached itin
     * - type: xs:string
     * @var string
     */
    public $CachePartition;
    /**
     * The CachePartitionPriority
     * Meta information extracted from the WSDL
     * - documentation: Indicates source partition priority of cached itin
     * - type: xs:nonNegativeInteger
     * @var int
     */
    public $CachePartitionPriority;
    /**
     * The CacheVersion
     * Meta information extracted from the WSDL
     * - documentation: Indicates source version of cached itin
     * - type: xs:string
     * @var string
     */
    public $CacheVersion;
    /**
     * The TimeToLive
     * Meta information extracted from the WSDL
     * - documentation: Time to live in cache (in minutes).
     * - type: xs:integer
     * - use: optional
     * @var int
     */
    public $TimeToLive;
    /**
     * The AlternateCityOption
     * Meta information extracted from the WSDL
     * - documentation: Indicates that this option is alternate dates option.
     * - default: false
     * - type: xs:boolean
     * @var bool
     */
    public $AlternateCityOption;
    /**
     * The PreviousExchangeDate
     * Meta information extracted from the WSDL
     * - documentation: Previous Exchange Date
     * - type: xs:date
     * @var string
     */
    public $PreviousExchangeDate;
    /**
     * The ReissueExchange
     * @var int
     */
    public $ReissueExchange;
    /**
     * The AdvancedPurchaseDate
     * Meta information extracted from the WSDL
     * - type: xs:date
     * @var string
     */
    public $AdvancedPurchaseDate;
    /**
     * The PurchaseByDate
     * Meta information extracted from the WSDL
     * - type: xs:date
     * @var string
     */
    public $PurchaseByDate;
    /**
     * Constructor method for AirItineraryPricingInfoType
     * @uses AirItineraryPricingInfoType::setItinTotalFare()
     * @uses AirItineraryPricingInfoType::setPTC_FareBreakdowns()
     * @uses AirItineraryPricingInfoType::setFareInfos()
     * @uses AirItineraryPricingInfoType::setTPA_Extensions()
     * @uses AirItineraryPricingInfoType::setLastTicketDate()
     * @uses AirItineraryPricingInfoType::setPrivateFareType()
     * @uses AirItineraryPricingInfoType::setSpanishFamilyDiscountIndicator()
     * @uses AirItineraryPricingInfoType::setFlexibleFareID()
     * @uses AirItineraryPricingInfoType::setPricingSource()
     * @uses AirItineraryPricingInfoType::setPricingSubSource()
     * @uses AirItineraryPricingInfoType::setPseudoCityCode()
     * @uses AirItineraryPricingInfoType::setBrandID()
     * @uses AirItineraryPricingInfoType::setFareReturned()
     * @uses AirItineraryPricingInfoType::setFareStatus()
     * @uses AirItineraryPricingInfoType::setCachedItin()
     * @uses AirItineraryPricingInfoType::setCachePartition()
     * @uses AirItineraryPricingInfoType::setCachePartitionPriority()
     * @uses AirItineraryPricingInfoType::setCacheVersion()
     * @uses AirItineraryPricingInfoType::setTimeToLive()
     * @uses AirItineraryPricingInfoType::setAlternateCityOption()
     * @uses AirItineraryPricingInfoType::setPreviousExchangeDate()
     * @uses AirItineraryPricingInfoType::setReissueExchange()
     * @uses AirItineraryPricingInfoType::setAdvancedPurchaseDate()
     * @uses AirItineraryPricingInfoType::setPurchaseByDate()
     * @param \SabreSoap\StructType\ItinTotalFareType $itinTotalFare
     * @param \SabreSoap\StructType\PTC_FareBreakdowns $pTC_FareBreakdowns
     * @param \SabreSoap\StructType\FareInfos $fareInfos
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param string $lastTicketDate
     * @param string $privateFareType
     * @param string $spanishFamilyDiscountIndicator
     * @param int $flexibleFareID
     * @param string $pricingSource
     * @param string $pricingSubSource
     * @param string $pseudoCityCode
     * @param string $brandID
     * @param bool $fareReturned
     * @param string $fareStatus
     * @param bool $cachedItin
     * @param string $cachePartition
     * @param int $cachePartitionPriority
     * @param string $cacheVersion
     * @param int $timeToLive
     * @param bool $alternateCityOption
     * @param string $previousExchangeDate
     * @param int $reissueExchange
     * @param string $advancedPurchaseDate
     * @param string $purchaseByDate
     */
    public function __construct(\SabreSoap\StructType\ItinTotalFareType $itinTotalFare = null, \SabreSoap\StructType\PTC_FareBreakdowns $pTC_FareBreakdowns = null, \SabreSoap\StructType\FareInfos $fareInfos = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, $lastTicketDate = null, $privateFareType = null, $spanishFamilyDiscountIndicator = null, $flexibleFareID = null, $pricingSource = null, $pricingSubSource = null, $pseudoCityCode = null, $brandID = null, $fareReturned = null, $fareStatus = null, $cachedItin = false, $cachePartition = null, $cachePartitionPriority = null, $cacheVersion = null, $timeToLive = null, $alternateCityOption = false, $previousExchangeDate = null, $reissueExchange = null, $advancedPurchaseDate = null, $purchaseByDate = null)
    {
        $this
            ->setItinTotalFare($itinTotalFare)
            ->setPTC_FareBreakdowns($pTC_FareBreakdowns)
            ->setFareInfos($fareInfos)
            ->setTPA_Extensions($tPA_Extensions)
            ->setLastTicketDate($lastTicketDate)
            ->setPrivateFareType($privateFareType)
            ->setSpanishFamilyDiscountIndicator($spanishFamilyDiscountIndicator)
            ->setFlexibleFareID($flexibleFareID)
            ->setPricingSource($pricingSource)
            ->setPricingSubSource($pricingSubSource)
            ->setPseudoCityCode($pseudoCityCode)
            ->setBrandID($brandID)
            ->setFareReturned($fareReturned)
            ->setFareStatus($fareStatus)
            ->setCachedItin($cachedItin)
            ->setCachePartition($cachePartition)
            ->setCachePartitionPriority($cachePartitionPriority)
            ->setCacheVersion($cacheVersion)
            ->setTimeToLive($timeToLive)
            ->setAlternateCityOption($alternateCityOption)
            ->setPreviousExchangeDate($previousExchangeDate)
            ->setReissueExchange($reissueExchange)
            ->setAdvancedPurchaseDate($advancedPurchaseDate)
            ->setPurchaseByDate($purchaseByDate);
    }
    /**
     * Get ItinTotalFare value
     * @return \SabreSoap\StructType\ItinTotalFareType|null
     */
    public function getItinTotalFare()
    {
        return $this->ItinTotalFare;
    }
    /**
     * Set ItinTotalFare value
     * @param \SabreSoap\StructType\ItinTotalFareType $itinTotalFare
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setItinTotalFare(\SabreSoap\StructType\ItinTotalFareType $itinTotalFare = null)
    {
        $this->ItinTotalFare = $itinTotalFare;
        return $this;
    }
    /**
     * Get PTC_FareBreakdowns value
     * @return \SabreSoap\StructType\PTC_FareBreakdowns|null
     */
    public function getPTC_FareBreakdowns()
    {
        return $this->PTC_FareBreakdowns;
    }
    /**
     * Set PTC_FareBreakdowns value
     * @param \SabreSoap\StructType\PTC_FareBreakdowns $pTC_FareBreakdowns
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setPTC_FareBreakdowns(\SabreSoap\StructType\PTC_FareBreakdowns $pTC_FareBreakdowns = null)
    {
        $this->PTC_FareBreakdowns = $pTC_FareBreakdowns;
        return $this;
    }
    /**
     * Get FareInfos value
     * @return \SabreSoap\StructType\FareInfos|null
     */
    public function getFareInfos()
    {
        return $this->FareInfos;
    }
    /**
     * Set FareInfos value
     * @param \SabreSoap\StructType\FareInfos $fareInfos
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setFareInfos(\SabreSoap\StructType\FareInfos $fareInfos = null)
    {
        $this->FareInfos = $fareInfos;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get LastTicketDate value
     * @return string|null
     */
    public function getLastTicketDate()
    {
        return $this->LastTicketDate;
    }
    /**
     * Set LastTicketDate value
     * @param string $lastTicketDate
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setLastTicketDate($lastTicketDate = null)
    {
        $this->LastTicketDate = $lastTicketDate;
        return $this;
    }
    /**
     * Get PrivateFareType value
     * @return string|null
     */
    public function getPrivateFareType()
    {
        return $this->PrivateFareType;
    }
    /**
     * Set PrivateFareType value
     * @param string $privateFareType
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setPrivateFareType($privateFareType = null)
    {
        $this->PrivateFareType = $privateFareType;
        return $this;
    }
    /**
     * Get SpanishFamilyDiscountIndicator value
     * @return string|null
     */
    public function getSpanishFamilyDiscountIndicator()
    {
        return $this->SpanishFamilyDiscountIndicator;
    }
    /**
     * Set SpanishFamilyDiscountIndicator value
     * @param string $spanishFamilyDiscountIndicator
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setSpanishFamilyDiscountIndicator($spanishFamilyDiscountIndicator = null)
    {
        $this->SpanishFamilyDiscountIndicator = $spanishFamilyDiscountIndicator;
        return $this;
    }
    /**
     * Get FlexibleFareID value
     * @return int|null
     */
    public function getFlexibleFareID()
    {
        return $this->FlexibleFareID;
    }
    /**
     * Set FlexibleFareID value
     * @param int $flexibleFareID
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setFlexibleFareID($flexibleFareID = null)
    {
        $this->FlexibleFareID = $flexibleFareID;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get PricingSubSource value
     * @return string|null
     */
    public function getPricingSubSource()
    {
        return $this->PricingSubSource;
    }
    /**
     * Set PricingSubSource value
     * @param string $pricingSubSource
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setPricingSubSource($pricingSubSource = null)
    {
        $this->PricingSubSource = $pricingSubSource;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get FareReturned value
     * @return bool|null
     */
    public function getFareReturned()
    {
        return $this->FareReturned;
    }
    /**
     * Set FareReturned value
     * @param bool $fareReturned
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setFareReturned($fareReturned = null)
    {
        $this->FareReturned = $fareReturned;
        return $this;
    }
    /**
     * Get FareStatus value
     * @return string|null
     */
    public function getFareStatus()
    {
        return $this->FareStatus;
    }
    /**
     * Set FareStatus value
     * @param string $fareStatus
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setFareStatus($fareStatus = null)
    {
        $this->FareStatus = $fareStatus;
        return $this;
    }
    /**
     * Get CachedItin value
     * @return bool|null
     */
    public function getCachedItin()
    {
        return $this->CachedItin;
    }
    /**
     * Set CachedItin value
     * @param bool $cachedItin
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setCachedItin($cachedItin = false)
    {
        $this->CachedItin = $cachedItin;
        return $this;
    }
    /**
     * Get CachePartition value
     * @return string|null
     */
    public function getCachePartition()
    {
        return $this->CachePartition;
    }
    /**
     * Set CachePartition value
     * @param string $cachePartition
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setCachePartition($cachePartition = null)
    {
        $this->CachePartition = $cachePartition;
        return $this;
    }
    /**
     * Get CachePartitionPriority value
     * @return int|null
     */
    public function getCachePartitionPriority()
    {
        return $this->CachePartitionPriority;
    }
    /**
     * Set CachePartitionPriority value
     * @param int $cachePartitionPriority
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setCachePartitionPriority($cachePartitionPriority = null)
    {
        $this->CachePartitionPriority = $cachePartitionPriority;
        return $this;
    }
    /**
     * Get CacheVersion value
     * @return string|null
     */
    public function getCacheVersion()
    {
        return $this->CacheVersion;
    }
    /**
     * Set CacheVersion value
     * @param string $cacheVersion
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setCacheVersion($cacheVersion = null)
    {
        $this->CacheVersion = $cacheVersion;
        return $this;
    }
    /**
     * Get TimeToLive value
     * @return int|null
     */
    public function getTimeToLive()
    {
        return $this->TimeToLive;
    }
    /**
     * Set TimeToLive value
     * @param int $timeToLive
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setTimeToLive($timeToLive = null)
    {
        $this->TimeToLive = $timeToLive;
        return $this;
    }
    /**
     * Get AlternateCityOption value
     * @return bool|null
     */
    public function getAlternateCityOption()
    {
        return $this->AlternateCityOption;
    }
    /**
     * Set AlternateCityOption value
     * @param bool $alternateCityOption
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setAlternateCityOption($alternateCityOption = false)
    {
        $this->AlternateCityOption = $alternateCityOption;
        return $this;
    }
    /**
     * Get PreviousExchangeDate value
     * @return string|null
     */
    public function getPreviousExchangeDate()
    {
        return $this->PreviousExchangeDate;
    }
    /**
     * Set PreviousExchangeDate value
     * @param string $previousExchangeDate
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setPreviousExchangeDate($previousExchangeDate = null)
    {
        $this->PreviousExchangeDate = $previousExchangeDate;
        return $this;
    }
    /**
     * Get ReissueExchange value
     * @return int|null
     */
    public function getReissueExchange()
    {
        return $this->ReissueExchange;
    }
    /**
     * Set ReissueExchange value
     * @param int $reissueExchange
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setReissueExchange($reissueExchange = null)
    {
        $this->ReissueExchange = $reissueExchange;
        return $this;
    }
    /**
     * Get AdvancedPurchaseDate value
     * @return string|null
     */
    public function getAdvancedPurchaseDate()
    {
        return $this->AdvancedPurchaseDate;
    }
    /**
     * Set AdvancedPurchaseDate value
     * @param string $advancedPurchaseDate
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setAdvancedPurchaseDate($advancedPurchaseDate = null)
    {
        $this->AdvancedPurchaseDate = $advancedPurchaseDate;
        return $this;
    }
    /**
     * Get PurchaseByDate value
     * @return string|null
     */
    public function getPurchaseByDate()
    {
        return $this->PurchaseByDate;
    }
    /**
     * Set PurchaseByDate value
     * @param string $purchaseByDate
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public function setPurchaseByDate($purchaseByDate = null)
    {
        $this->PurchaseByDate = $purchaseByDate;
        return $this;
    }
}
