<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncReply StructType
 * @subpackage Structs
 */
class SyncReply extends AbstractStructBase
{
    /**
     * The actor
     * Meta information extracted from the WSDL
     * - ref: soap:actor
     * - use: required
     * @var string
     */
    public $actor;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for SyncReply
     * @uses SyncReply::setActor()
     * @uses SyncReply::setAny()
     * @uses SyncReply::setId()
     * @uses SyncReply::setVersion()
     * @param string $actor
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct($actor = null, \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setActor($actor)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get actor value
     * @return string
     */
    public function getActor()
    {
        return $this->actor;
    }
    /**
     * Set actor value
     * @param string $actor
     * @return \SabreSoap\StructType\SyncReply
     */
    public function setActor($actor = null)
    {
        $this->actor = $actor;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\SyncReply
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabreSoap\StructType\SyncReply
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabreSoap\StructType\SyncReply
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
}
