<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecifiedLocation StructType
 * Meta information extracted from the WSDL
 * - documentation: A desired location (airport city).
 * @subpackage Structs
 */
class SpecifiedLocation extends AbstractStructBase
{
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [A-Z]*
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * Constructor method for SpecifiedLocation
     * @uses SpecifiedLocation::setLocationCode()
     * @param string $locationCode
     */
    public function __construct($locationCode = null)
    {
        $this
            ->setLocationCode($locationCode);
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \SabreSoap\StructType\SpecifiedLocation
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
}
