<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirLowFareSearchRS StructType
 * Meta information extracted from the WSDL
 * - documentation: The Low Fare Search Response message contains a number of .Priced Itinerary. options. Each includes: - A set of available flights matching the client.s request. - Pricing information including taxes and full fare breakdown for each
 * passenger type - Ticketing information - Fare Basis Codes and the information necessary to make a rules entry. This message contains similar information to a standard airline CRS or GDS Low Fare Search Response message.
 * @subpackage Structs
 */
class OTA_AirLowFareSearchRS extends AbstractStructBase
{
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - documentation: In case of failure errors are returned.
     * - choice: Errors | Success | Warnings | PricedItineraries | OneWayItineraries | DepartedItineraries | SoldOutItineraries | AvailableItineraries | TPA_Extensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ErrorsType
     */
    public $Errors;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - documentation: In case of success this element is returned.
     * - choice: Errors | Success | Warnings | PricedItineraries | OneWayItineraries | DepartedItineraries | SoldOutItineraries | AvailableItineraries | TPA_Extensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - documentation: In case of any warnings this element is returned.
     * - choice: Errors | Success | Warnings | PricedItineraries | OneWayItineraries | DepartedItineraries | SoldOutItineraries | AvailableItineraries | TPA_Extensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\WarningsType
     */
    public $Warnings;
    /**
     * The PricedItineraries
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | Warnings | PricedItineraries | OneWayItineraries | DepartedItineraries | SoldOutItineraries | AvailableItineraries | TPA_Extensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PricedItineraries
     */
    public $PricedItineraries;
    /**
     * The OneWayItineraries
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | Warnings | PricedItineraries | OneWayItineraries | DepartedItineraries | SoldOutItineraries | AvailableItineraries | TPA_Extensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\OneWayItineraries
     */
    public $OneWayItineraries;
    /**
     * The DepartedItineraries
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | Warnings | PricedItineraries | OneWayItineraries | DepartedItineraries | SoldOutItineraries | AvailableItineraries | TPA_Extensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\DepartedItineraries
     */
    public $DepartedItineraries;
    /**
     * The SoldOutItineraries
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | Warnings | PricedItineraries | OneWayItineraries | DepartedItineraries | SoldOutItineraries | AvailableItineraries | TPA_Extensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SoldOutItineraries
     */
    public $SoldOutItineraries;
    /**
     * The AvailableItineraries
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | Warnings | PricedItineraries | OneWayItineraries | DepartedItineraries | SoldOutItineraries | AvailableItineraries | TPA_Extensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AvailableItineraries
     */
    public $AvailableItineraries;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - choice: Errors | Success | Warnings | PricedItineraries | OneWayItineraries | DepartedItineraries | SoldOutItineraries | AvailableItineraries | TPA_Extensions
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The PricedItinCount
     * Meta information extracted from the WSDL
     * - documentation: Itinerary count for Priced Round-Trip itineraries
     * - use: optional
     * @var int
     */
    public $PricedItinCount;
    /**
     * The BrandedOneWayItinCount
     * Meta information extracted from the WSDL
     * - documentation: Itinerary count for Branded One-Way itineraries
     * - use: optional
     * @var int
     */
    public $BrandedOneWayItinCount;
    /**
     * The SimpleOneWayItinCount
     * Meta information extracted from the WSDL
     * - documentation: Itinerary count for Simple One-Way itineraries
     * - use: optional
     * @var int
     */
    public $SimpleOneWayItinCount;
    /**
     * The DepartedItinCount
     * Meta information extracted from the WSDL
     * - documentation: Itinerary count for departed itineraries returned
     * - use: optional
     * @var int
     */
    public $DepartedItinCount;
    /**
     * The SoldOutItinCount
     * Meta information extracted from the WSDL
     * - documentation: Itinerary count for sold out itineraries returned
     * - use: optional
     * @var int
     */
    public $SoldOutItinCount;
    /**
     * The AvailableItinCount
     * Meta information extracted from the WSDL
     * - documentation: Itinerary count for available itineraries returned
     * - use: optional
     * @var int
     */
    public $AvailableItinCount;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * Meta information extracted from the WSDL
     * - union: positiveInteger | boolean
     * @var string
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for OTA_AirLowFareSearchRS
     * @uses OTA_AirLowFareSearchRS::setErrors()
     * @uses OTA_AirLowFareSearchRS::setSuccess()
     * @uses OTA_AirLowFareSearchRS::setWarnings()
     * @uses OTA_AirLowFareSearchRS::setPricedItineraries()
     * @uses OTA_AirLowFareSearchRS::setOneWayItineraries()
     * @uses OTA_AirLowFareSearchRS::setDepartedItineraries()
     * @uses OTA_AirLowFareSearchRS::setSoldOutItineraries()
     * @uses OTA_AirLowFareSearchRS::setAvailableItineraries()
     * @uses OTA_AirLowFareSearchRS::setTPA_Extensions()
     * @uses OTA_AirLowFareSearchRS::setPricedItinCount()
     * @uses OTA_AirLowFareSearchRS::setBrandedOneWayItinCount()
     * @uses OTA_AirLowFareSearchRS::setSimpleOneWayItinCount()
     * @uses OTA_AirLowFareSearchRS::setDepartedItinCount()
     * @uses OTA_AirLowFareSearchRS::setSoldOutItinCount()
     * @uses OTA_AirLowFareSearchRS::setAvailableItinCount()
     * @uses OTA_AirLowFareSearchRS::setEchoToken()
     * @uses OTA_AirLowFareSearchRS::setTimeStamp()
     * @uses OTA_AirLowFareSearchRS::setTarget()
     * @uses OTA_AirLowFareSearchRS::setVersion()
     * @uses OTA_AirLowFareSearchRS::setTransactionIdentifier()
     * @uses OTA_AirLowFareSearchRS::setSequenceNmbr()
     * @uses OTA_AirLowFareSearchRS::setTransactionStatusCode()
     * @uses OTA_AirLowFareSearchRS::setPrimaryLangID()
     * @uses OTA_AirLowFareSearchRS::setAltLangID()
     * @param \SabreSoap\StructType\ErrorsType $errors
     * @param \SabreSoap\StructType\SuccessType $success
     * @param \SabreSoap\StructType\WarningsType $warnings
     * @param \SabreSoap\StructType\PricedItineraries $pricedItineraries
     * @param \SabreSoap\StructType\OneWayItineraries $oneWayItineraries
     * @param \SabreSoap\StructType\DepartedItineraries $departedItineraries
     * @param \SabreSoap\StructType\SoldOutItineraries $soldOutItineraries
     * @param \SabreSoap\StructType\AvailableItineraries $availableItineraries
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param int $pricedItinCount
     * @param int $brandedOneWayItinCount
     * @param int $simpleOneWayItinCount
     * @param int $departedItinCount
     * @param int $soldOutItinCount
     * @param int $availableItinCount
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $version
     * @param string $transactionIdentifier
     * @param string $sequenceNmbr
     * @param string $transactionStatusCode
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct(\SabreSoap\StructType\ErrorsType $errors = null, \SabreSoap\StructType\SuccessType $success = null, \SabreSoap\StructType\WarningsType $warnings = null, \SabreSoap\StructType\PricedItineraries $pricedItineraries = null, \SabreSoap\StructType\OneWayItineraries $oneWayItineraries = null, \SabreSoap\StructType\DepartedItineraries $departedItineraries = null, \SabreSoap\StructType\SoldOutItineraries $soldOutItineraries = null, \SabreSoap\StructType\AvailableItineraries $availableItineraries = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, $pricedItinCount = null, $brandedOneWayItinCount = null, $simpleOneWayItinCount = null, $departedItinCount = null, $soldOutItinCount = null, $availableItinCount = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setErrors($errors)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setPricedItineraries($pricedItineraries)
            ->setOneWayItineraries($oneWayItineraries)
            ->setDepartedItineraries($departedItineraries)
            ->setSoldOutItineraries($soldOutItineraries)
            ->setAvailableItineraries($availableItineraries)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPricedItinCount($pricedItinCount)
            ->setBrandedOneWayItinCount($brandedOneWayItinCount)
            ->setSimpleOneWayItinCount($simpleOneWayItinCount)
            ->setDepartedItinCount($departedItinCount)
            ->setSoldOutItinCount($soldOutItinCount)
            ->setAvailableItinCount($availableItinCount)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get Errors value
     * @return \SabreSoap\StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\ErrorsType $errors
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setErrors(\SabreSoap\StructType\ErrorsType $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return \SabreSoap\StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\SuccessType $success
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setSuccess(\SabreSoap\StructType\SuccessType $success = null)
    {
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return \SabreSoap\StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\WarningsType $warnings
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setWarnings(\SabreSoap\StructType\WarningsType $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get PricedItineraries value
     * @return \SabreSoap\StructType\PricedItineraries|null
     */
    public function getPricedItineraries()
    {
        return isset($this->PricedItineraries) ? $this->PricedItineraries : null;
    }
    /**
     * Set PricedItineraries value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\PricedItineraries $pricedItineraries
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setPricedItineraries(\SabreSoap\StructType\PricedItineraries $pricedItineraries = null)
    {
        if (is_null($pricedItineraries) || (is_array($pricedItineraries) && empty($pricedItineraries))) {
            unset($this->PricedItineraries);
        } else {
            $this->PricedItineraries = $pricedItineraries;
        }
        return $this;
    }
    /**
     * Get OneWayItineraries value
     * @return \SabreSoap\StructType\OneWayItineraries|null
     */
    public function getOneWayItineraries()
    {
        return isset($this->OneWayItineraries) ? $this->OneWayItineraries : null;
    }
    /**
     * Set OneWayItineraries value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\OneWayItineraries $oneWayItineraries
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setOneWayItineraries(\SabreSoap\StructType\OneWayItineraries $oneWayItineraries = null)
    {
        if (is_null($oneWayItineraries) || (is_array($oneWayItineraries) && empty($oneWayItineraries))) {
            unset($this->OneWayItineraries);
        } else {
            $this->OneWayItineraries = $oneWayItineraries;
        }
        return $this;
    }
    /**
     * Get DepartedItineraries value
     * @return \SabreSoap\StructType\DepartedItineraries|null
     */
    public function getDepartedItineraries()
    {
        return isset($this->DepartedItineraries) ? $this->DepartedItineraries : null;
    }
    /**
     * Set DepartedItineraries value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\DepartedItineraries $departedItineraries
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setDepartedItineraries(\SabreSoap\StructType\DepartedItineraries $departedItineraries = null)
    {
        if (is_null($departedItineraries) || (is_array($departedItineraries) && empty($departedItineraries))) {
            unset($this->DepartedItineraries);
        } else {
            $this->DepartedItineraries = $departedItineraries;
        }
        return $this;
    }
    /**
     * Get SoldOutItineraries value
     * @return \SabreSoap\StructType\SoldOutItineraries|null
     */
    public function getSoldOutItineraries()
    {
        return isset($this->SoldOutItineraries) ? $this->SoldOutItineraries : null;
    }
    /**
     * Set SoldOutItineraries value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\SoldOutItineraries $soldOutItineraries
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setSoldOutItineraries(\SabreSoap\StructType\SoldOutItineraries $soldOutItineraries = null)
    {
        if (is_null($soldOutItineraries) || (is_array($soldOutItineraries) && empty($soldOutItineraries))) {
            unset($this->SoldOutItineraries);
        } else {
            $this->SoldOutItineraries = $soldOutItineraries;
        }
        return $this;
    }
    /**
     * Get AvailableItineraries value
     * @return \SabreSoap\StructType\AvailableItineraries|null
     */
    public function getAvailableItineraries()
    {
        return isset($this->AvailableItineraries) ? $this->AvailableItineraries : null;
    }
    /**
     * Set AvailableItineraries value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\AvailableItineraries $availableItineraries
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setAvailableItineraries(\SabreSoap\StructType\AvailableItineraries $availableItineraries = null)
    {
        if (is_null($availableItineraries) || (is_array($availableItineraries) && empty($availableItineraries))) {
            unset($this->AvailableItineraries);
        } else {
            $this->AvailableItineraries = $availableItineraries;
        }
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return isset($this->TPA_Extensions) ? $this->TPA_Extensions : null;
    }
    /**
     * Set TPA_Extensions value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        if (is_null($tPA_Extensions) || (is_array($tPA_Extensions) && empty($tPA_Extensions))) {
            unset($this->TPA_Extensions);
        } else {
            $this->TPA_Extensions = $tPA_Extensions;
        }
        return $this;
    }
    /**
     * Get PricedItinCount value
     * @return int|null
     */
    public function getPricedItinCount()
    {
        return $this->PricedItinCount;
    }
    /**
     * Set PricedItinCount value
     * @param int $pricedItinCount
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setPricedItinCount($pricedItinCount = null)
    {
        $this->PricedItinCount = $pricedItinCount;
        return $this;
    }
    /**
     * Get BrandedOneWayItinCount value
     * @return int|null
     */
    public function getBrandedOneWayItinCount()
    {
        return $this->BrandedOneWayItinCount;
    }
    /**
     * Set BrandedOneWayItinCount value
     * @param int $brandedOneWayItinCount
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setBrandedOneWayItinCount($brandedOneWayItinCount = null)
    {
        $this->BrandedOneWayItinCount = $brandedOneWayItinCount;
        return $this;
    }
    /**
     * Get SimpleOneWayItinCount value
     * @return int|null
     */
    public function getSimpleOneWayItinCount()
    {
        return $this->SimpleOneWayItinCount;
    }
    /**
     * Set SimpleOneWayItinCount value
     * @param int $simpleOneWayItinCount
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setSimpleOneWayItinCount($simpleOneWayItinCount = null)
    {
        $this->SimpleOneWayItinCount = $simpleOneWayItinCount;
        return $this;
    }
    /**
     * Get DepartedItinCount value
     * @return int|null
     */
    public function getDepartedItinCount()
    {
        return $this->DepartedItinCount;
    }
    /**
     * Set DepartedItinCount value
     * @param int $departedItinCount
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setDepartedItinCount($departedItinCount = null)
    {
        $this->DepartedItinCount = $departedItinCount;
        return $this;
    }
    /**
     * Get SoldOutItinCount value
     * @return int|null
     */
    public function getSoldOutItinCount()
    {
        return $this->SoldOutItinCount;
    }
    /**
     * Set SoldOutItinCount value
     * @param int $soldOutItinCount
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setSoldOutItinCount($soldOutItinCount = null)
    {
        $this->SoldOutItinCount = $soldOutItinCount;
        return $this;
    }
    /**
     * Get AvailableItinCount value
     * @return int|null
     */
    public function getAvailableItinCount()
    {
        return $this->AvailableItinCount;
    }
    /**
     * Set AvailableItinCount value
     * @param int $availableItinCount
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setAvailableItinCount($availableItinCount = null)
    {
        $this->AvailableItinCount = $availableItinCount;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setEchoToken($echoToken = null)
    {
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setTarget($target = null)
    {
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return string|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param string $sequenceNmbr
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \SabreSoap\StructType\OTA_AirLowFareSearchRS
     */
    public function setAltLangID($altLangID = null)
    {
        $this->AltLangID = $altLangID;
        return $this;
    }
}
