<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponentTaxesType StructType
 * @subpackage Structs
 */
class FareComponentTaxesType extends AbstractStructBase
{
    /**
     * The FlightSegment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \SabreSoap\StructType\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: Any individual tax applied to the fare
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AirTaxType[]
     */
    public $Tax;
    /**
     * Constructor method for FareComponentTaxesType
     * @uses FareComponentTaxesType::setFlightSegment()
     * @uses FareComponentTaxesType::setTax()
     * @param \SabreSoap\StructType\FlightSegment[] $flightSegment
     * @param \SabreSoap\StructType\AirTaxType[] $tax
     */
    public function __construct(array $flightSegment = array(), array $tax = array())
    {
        $this
            ->setFlightSegment($flightSegment)
            ->setTax($tax);
    }
    /**
     * Get FlightSegment value
     * @return \SabreSoap\StructType\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @param \SabreSoap\StructType\FlightSegment[] $flightSegment
     * @return \SabreSoap\StructType\FareComponentTaxesType
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\FlightSegment $item
     * @return \SabreSoap\StructType\FareComponentTaxesType
     */
    public function addToFlightSegment(\SabreSoap\StructType\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get Tax value
     * @return \SabreSoap\StructType\AirTaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param \SabreSoap\StructType\AirTaxType[] $tax
     * @return \SabreSoap\StructType\FareComponentTaxesType
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AirTaxType $item
     * @return \SabreSoap\StructType\FareComponentTaxesType
     */
    public function addToTax(\SabreSoap\StructType\AirTaxType $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
}
