<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information on a specific documents.
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The DocHolderName
     * Meta information extracted from the WSDL
     * - documentation: Specify document holder name. | Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocHolderName;
    /**
     * The DocLimitations
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate any limitations on the document (e.g. as a person may only be allowed to spend a max of 30 days in country on a visitor's visa). | Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - maxOccurs: 9
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $DocLimitations;
    /**
     * The DocIssueAuthority
     * Meta information extracted from the WSDL
     * - documentation: Indicates the group or association that granted the document. | Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $DocIssueAuthority;
    /**
     * The DocIssueLocation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the location where the document was issued. | Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $DocIssueLocation;
    /**
     * The DocID
     * Meta information extracted from the WSDL
     * - documentation: Unique number assigned by authorities to document. | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $DocID;
    /**
     * The DocType
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of document (e.g. Passport, Military ID, Drivers License, national ID, Vaccination Certificate). Refer to OTA Code List Document Type (DOC). | Used for codes in the OTA code tables. Possible values of this pattern
     * are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - use: optional
     * @var string
     */
    public $DocType;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $BirthDate;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setDocHolderName()
     * @uses DocumentType::setDocLimitations()
     * @uses DocumentType::setDocIssueAuthority()
     * @uses DocumentType::setDocIssueLocation()
     * @uses DocumentType::setDocID()
     * @uses DocumentType::setDocType()
     * @uses DocumentType::setShareSynchInd()
     * @uses DocumentType::setShareMarketInd()
     * @uses DocumentType::setGender()
     * @uses DocumentType::setBirthDate()
     * @uses DocumentType::setEffectiveDate()
     * @uses DocumentType::setExpireDate()
     * @param string $docHolderName
     * @param string[] $docLimitations
     * @param string $docIssueAuthority
     * @param string $docIssueLocation
     * @param string $docID
     * @param string $docType
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $gender
     * @param string $birthDate
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct($docHolderName = null, array $docLimitations = array(), $docIssueAuthority = null, $docIssueLocation = null, $docID = null, $docType = null, $shareSynchInd = null, $shareMarketInd = null, $gender = null, $birthDate = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setDocHolderName($docHolderName)
            ->setDocLimitations($docLimitations)
            ->setDocIssueAuthority($docIssueAuthority)
            ->setDocIssueLocation($docIssueLocation)
            ->setDocID($docID)
            ->setDocType($docType)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setGender($gender)
            ->setBirthDate($birthDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get DocHolderName value
     * @return string|null
     */
    public function getDocHolderName()
    {
        return $this->DocHolderName;
    }
    /**
     * Set DocHolderName value
     * @param string $docHolderName
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setDocHolderName($docHolderName = null)
    {
        $this->DocHolderName = $docHolderName;
        return $this;
    }
    /**
     * Get DocLimitations value
     * @return string[]|null
     */
    public function getDocLimitations()
    {
        return $this->DocLimitations;
    }
    /**
     * Set DocLimitations value
     * @param string[] $docLimitations
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setDocLimitations(array $docLimitations = array())
    {
        $this->DocLimitations = $docLimitations;
        return $this;
    }
    /**
     * Add item to DocLimitations value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\DocumentType
     */
    public function addToDocLimitations($item)
    {
        $this->DocLimitations[] = $item;
        return $this;
    }
    /**
     * Get DocIssueAuthority value
     * @return string|null
     */
    public function getDocIssueAuthority()
    {
        return $this->DocIssueAuthority;
    }
    /**
     * Set DocIssueAuthority value
     * @param string $docIssueAuthority
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setDocIssueAuthority($docIssueAuthority = null)
    {
        $this->DocIssueAuthority = $docIssueAuthority;
        return $this;
    }
    /**
     * Get DocIssueLocation value
     * @return string|null
     */
    public function getDocIssueLocation()
    {
        return $this->DocIssueLocation;
    }
    /**
     * Set DocIssueLocation value
     * @param string $docIssueLocation
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setDocIssueLocation($docIssueLocation = null)
    {
        $this->DocIssueLocation = $docIssueLocation;
        return $this;
    }
    /**
     * Get DocID value
     * @return string|null
     */
    public function getDocID()
    {
        return $this->DocID;
    }
    /**
     * Set DocID value
     * @param string $docID
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setDocID($docID = null)
    {
        $this->DocID = $docID;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setDocType($docType = null)
    {
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setGender($gender = null)
    {
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setBirthDate($birthDate = null)
    {
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \SabreSoap\StructType\DocumentType
     */
    public function setExpireDate($expireDate = null)
    {
        $this->ExpireDate = $expireDate;
        return $this;
    }
}
