<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegmentRPHs StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference pointers to flight segments
 * @subpackage Structs
 */
class FlightSegmentRPHs extends AbstractStructBase
{
    /**
     * The FlightSegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to the flight segments for this traveler | (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used to assign individual passengers or clients to particular
     * itinerary items.
     * - base: xs:string
     * - maxOccurs: 99
     * - pattern: [0-9]{1,8}
     * @var string[]
     */
    public $FlightSegmentRPH;
    /**
     * Constructor method for FlightSegmentRPHs
     * @uses FlightSegmentRPHs::setFlightSegmentRPH()
     * @param string[] $flightSegmentRPH
     */
    public function __construct(array $flightSegmentRPH = array())
    {
        $this
            ->setFlightSegmentRPH($flightSegmentRPH);
    }
    /**
     * Get FlightSegmentRPH value
     * @return string[]|null
     */
    public function getFlightSegmentRPH()
    {
        return $this->FlightSegmentRPH;
    }
    /**
     * Set FlightSegmentRPH value
     * @param string[] $flightSegmentRPH
     * @return \SabreSoap\StructType\FlightSegmentRPHs
     */
    public function setFlightSegmentRPH(array $flightSegmentRPH = array())
    {
        $this->FlightSegmentRPH = $flightSegmentRPH;
        return $this;
    }
    /**
     * Add item to FlightSegmentRPH value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\FlightSegmentRPHs
     */
    public function addToFlightSegmentRPH($item)
    {
        $this->FlightSegmentRPH[] = $item;
        return $this;
    }
}
