<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManifestType StructType
 * @subpackage Structs
 */
class ManifestType extends AbstractStructBase
{
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:Reference
     * @var \SabreSoap\StructType\ReferenceType[]
     */
    public $Reference;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ManifestType
     * @uses ManifestType::setReference()
     * @uses ManifestType::setId()
     * @param \SabreSoap\StructType\ReferenceType[] $reference
     * @param string $id
     */
    public function __construct(array $reference = array(), $id = null)
    {
        $this
            ->setReference($reference)
            ->setId($id);
    }
    /**
     * Get Reference value
     * @return \SabreSoap\StructType\ReferenceType[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \SabreSoap\StructType\ReferenceType[] $reference
     * @return \SabreSoap\StructType\ManifestType
     */
    public function setReference(array $reference = array())
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\ReferenceType $item
     * @return \SabreSoap\StructType\ManifestType
     */
    public function addToReference(\SabreSoap\StructType\ReferenceType $item)
    {
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabreSoap\StructType\ManifestType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
}
