<?php

namespace SabreSoap\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ActionCodeType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the action code for a booking - OK, Waitlist etc.
 * @subpackage Enumerations
 */
class ActionCodeType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'Waitlist'
     * @return string 'Waitlist'
     */
    const VALUE_WAITLIST = 'Waitlist';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_WAITLIST
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_WAITLIST,
            self::VALUE_OTHER,
        );
    }
}
