<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFee StructType
 * @subpackage Structs
 */
class ServiceFee extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Service Fee Amount | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Service Fee Tax | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: required
     * @var float
     */
    public $TaxAmount;
    /**
     * Constructor method for ServiceFee
     * @uses ServiceFee::setAmount()
     * @uses ServiceFee::setTaxAmount()
     * @param float $amount
     * @param float $taxAmount
     */
    public function __construct($amount = null, $taxAmount = null)
    {
        $this
            ->setAmount($amount)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SabreSoap\StructType\ServiceFee
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \SabreSoap\StructType\ServiceFee
     */
    public function setTaxAmount($taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
}
