<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationFlightType StructType
 * @subpackage Structs
 */
class OriginDestinationFlightType extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Flight number
     * - type: xs:short
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: Departure date and time | IntelliSell DateTime type with optional seconds component (required format: YYYY-MM-DDTHH:MM or YYYY-MM-DDTHH:MM:SS)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}(:[0-9]{2})?
     * - type: ISellDateTimeType
     * - use: required
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: Arrival date and time | IntelliSell DateTime type with optional seconds component (required format: YYYY-MM-DDTHH:MM or YYYY-MM-DDTHH:MM:SS)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}(:[0-9]{2})?
     * - type: ISellDateTimeType
     * - use: required
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The OriginLocation
     * @var \SabreSoap\StructType\RequestLocationType
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \SabreSoap\StructType\RequestLocationType
     */
    public $DestinationLocation;
    /**
     * The Airline
     * @var \SabreSoap\StructType\AirlineType
     */
    public $Airline;
    /**
     * The SideTrip
     * @var \SabreSoap\StructType\SideTripType
     */
    public $SideTrip;
    /**
     * The Reservation
     * @var \SabreSoap\StructType\ReservationType
     */
    public $Reservation;
    /**
     * The MileageDisplay
     * @var \SabreSoap\StructType\MileageDisplayType
     */
    public $MileageDisplay;
    /**
     * The BookingDateTime
     * Meta information extracted from the WSDL
     * - documentation: IntelliSell DateTime type with optional seconds component (required format: YYYY-MM-DDTHH:MM or YYYY-MM-DDTHH:MM:SS)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}(:[0-9]{2})?
     * @var string
     */
    public $BookingDateTime;
    /**
     * The Fare
     * @var \SabreSoap\StructType\FareOptionalDetailsType
     */
    public $Fare;
    /**
     * The PlusUp
     * @var \SabreSoap\StructType\PlusUpType
     */
    public $PlusUp;
    /**
     * The MarriageStatus
     * Meta information extracted from the WSDL
     * - documentation: Marriage status
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $MarriageStatus;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Flown
     * Meta information extracted from the WSDL
     * - documentation: Specify whether the flight is flown.
     * - default: false
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Flown;
    /**
     * The ClassOfService
     * Meta information extracted from the WSDL
     * - documentation: Class of service
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - type: ClassOfServiceType
     * - use: optional
     * @var string
     */
    public $ClassOfService;
    /**
     * The Shopped
     * Meta information extracted from the WSDL
     * - documentation: Specify whether the flight is shopped.
     * - default: false
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Shopped;
    /**
     * Constructor method for OriginDestinationFlightType
     * @uses OriginDestinationFlightType::setNumber()
     * @uses OriginDestinationFlightType::setDepartureDateTime()
     * @uses OriginDestinationFlightType::setArrivalDateTime()
     * @uses OriginDestinationFlightType::setOriginLocation()
     * @uses OriginDestinationFlightType::setDestinationLocation()
     * @uses OriginDestinationFlightType::setAirline()
     * @uses OriginDestinationFlightType::setSideTrip()
     * @uses OriginDestinationFlightType::setReservation()
     * @uses OriginDestinationFlightType::setMileageDisplay()
     * @uses OriginDestinationFlightType::setBookingDateTime()
     * @uses OriginDestinationFlightType::setFare()
     * @uses OriginDestinationFlightType::setPlusUp()
     * @uses OriginDestinationFlightType::setMarriageStatus()
     * @uses OriginDestinationFlightType::setType()
     * @uses OriginDestinationFlightType::setFlown()
     * @uses OriginDestinationFlightType::setClassOfService()
     * @uses OriginDestinationFlightType::setShopped()
     * @param int $number
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param \SabreSoap\StructType\RequestLocationType $originLocation
     * @param \SabreSoap\StructType\RequestLocationType $destinationLocation
     * @param \SabreSoap\StructType\AirlineType $airline
     * @param \SabreSoap\StructType\SideTripType $sideTrip
     * @param \SabreSoap\StructType\ReservationType $reservation
     * @param \SabreSoap\StructType\MileageDisplayType $mileageDisplay
     * @param string $bookingDateTime
     * @param \SabreSoap\StructType\FareOptionalDetailsType $fare
     * @param \SabreSoap\StructType\PlusUpType $plusUp
     * @param string $marriageStatus
     * @param string $type
     * @param bool $flown
     * @param string $classOfService
     * @param bool $shopped
     */
    public function __construct($number = null, $departureDateTime = null, $arrivalDateTime = null, \SabreSoap\StructType\RequestLocationType $originLocation = null, \SabreSoap\StructType\RequestLocationType $destinationLocation = null, \SabreSoap\StructType\AirlineType $airline = null, \SabreSoap\StructType\SideTripType $sideTrip = null, \SabreSoap\StructType\ReservationType $reservation = null, \SabreSoap\StructType\MileageDisplayType $mileageDisplay = null, $bookingDateTime = null, \SabreSoap\StructType\FareOptionalDetailsType $fare = null, \SabreSoap\StructType\PlusUpType $plusUp = null, $marriageStatus = null, $type = null, $flown = false, $classOfService = null, $shopped = false)
    {
        $this
            ->setNumber($number)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setAirline($airline)
            ->setSideTrip($sideTrip)
            ->setReservation($reservation)
            ->setMileageDisplay($mileageDisplay)
            ->setBookingDateTime($bookingDateTime)
            ->setFare($fare)
            ->setPlusUp($plusUp)
            ->setMarriageStatus($marriageStatus)
            ->setType($type)
            ->setFlown($flown)
            ->setClassOfService($classOfService)
            ->setShopped($shopped);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \SabreSoap\StructType\RequestLocationType|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \SabreSoap\StructType\RequestLocationType $originLocation
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setOriginLocation(\SabreSoap\StructType\RequestLocationType $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \SabreSoap\StructType\RequestLocationType|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \SabreSoap\StructType\RequestLocationType $destinationLocation
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setDestinationLocation(\SabreSoap\StructType\RequestLocationType $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get Airline value
     * @return \SabreSoap\StructType\AirlineType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \SabreSoap\StructType\AirlineType $airline
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setAirline(\SabreSoap\StructType\AirlineType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get SideTrip value
     * @return \SabreSoap\StructType\SideTripType|null
     */
    public function getSideTrip()
    {
        return $this->SideTrip;
    }
    /**
     * Set SideTrip value
     * @param \SabreSoap\StructType\SideTripType $sideTrip
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setSideTrip(\SabreSoap\StructType\SideTripType $sideTrip = null)
    {
        $this->SideTrip = $sideTrip;
        return $this;
    }
    /**
     * Get Reservation value
     * @return \SabreSoap\StructType\ReservationType|null
     */
    public function getReservation()
    {
        return $this->Reservation;
    }
    /**
     * Set Reservation value
     * @param \SabreSoap\StructType\ReservationType $reservation
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setReservation(\SabreSoap\StructType\ReservationType $reservation = null)
    {
        $this->Reservation = $reservation;
        return $this;
    }
    /**
     * Get MileageDisplay value
     * @return \SabreSoap\StructType\MileageDisplayType|null
     */
    public function getMileageDisplay()
    {
        return $this->MileageDisplay;
    }
    /**
     * Set MileageDisplay value
     * @param \SabreSoap\StructType\MileageDisplayType $mileageDisplay
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setMileageDisplay(\SabreSoap\StructType\MileageDisplayType $mileageDisplay = null)
    {
        $this->MileageDisplay = $mileageDisplay;
        return $this;
    }
    /**
     * Get BookingDateTime value
     * @return string|null
     */
    public function getBookingDateTime()
    {
        return $this->BookingDateTime;
    }
    /**
     * Set BookingDateTime value
     * @param string $bookingDateTime
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setBookingDateTime($bookingDateTime = null)
    {
        $this->BookingDateTime = $bookingDateTime;
        return $this;
    }
    /**
     * Get Fare value
     * @return \SabreSoap\StructType\FareOptionalDetailsType|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \SabreSoap\StructType\FareOptionalDetailsType $fare
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setFare(\SabreSoap\StructType\FareOptionalDetailsType $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get PlusUp value
     * @return \SabreSoap\StructType\PlusUpType|null
     */
    public function getPlusUp()
    {
        return $this->PlusUp;
    }
    /**
     * Set PlusUp value
     * @param \SabreSoap\StructType\PlusUpType $plusUp
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setPlusUp(\SabreSoap\StructType\PlusUpType $plusUp = null)
    {
        $this->PlusUp = $plusUp;
        return $this;
    }
    /**
     * Get MarriageStatus value
     * @return string|null
     */
    public function getMarriageStatus()
    {
        return $this->MarriageStatus;
    }
    /**
     * Set MarriageStatus value
     * @param string $marriageStatus
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setMarriageStatus($marriageStatus = null)
    {
        $this->MarriageStatus = $marriageStatus;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Flown value
     * @return bool|null
     */
    public function getFlown()
    {
        return $this->Flown;
    }
    /**
     * Set Flown value
     * @param bool $flown
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setFlown($flown = false)
    {
        $this->Flown = $flown;
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return string|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param string $classOfService
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setClassOfService($classOfService = null)
    {
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get Shopped value
     * @return bool|null
     */
    public function getShopped()
    {
        return $this->Shopped;
    }
    /**
     * Set Shopped value
     * @param bool $shopped
     * @return \SabreSoap\StructType\OriginDestinationFlightType
     */
    public function setShopped($shopped = false)
    {
        $this->Shopped = $shopped;
        return $this;
    }
}
