<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NegotiatedFareCode StructType
 * Meta information extracted from the WSDL
 * - type: xs:string
 * - use: optional
 * @subpackage Structs
 */
class NegotiatedFareCode extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - documentation: This element indicates the supplier associated with a negotiated fare code.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CompanyNameType[]
     */
    public $Supplier;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - documentation: This is a place holder for additional elements.
     * - minOccurs: 0
     * @var string
     */
    public $TPA_Extensions;
    /**
     * The SecondaryCode
     * Meta information extracted from the WSDL
     * - documentation: An additional attribute to allow flexibility for particular organizations who require an additional code. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $SecondaryCode;
    /**
     * The SupplierCode
     * Meta information extracted from the WSDL
     * - documentation: An additional attribute to allow flexibility for particular organizations who require an additional supplier code. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $SupplierCode;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Any code used to specify an item, for example, type of traveler, service code, room amenity, etc. | Corporate ID
     * - base: xs:string
     * - pattern: [A-Za-z]{3}[0-9]{2}
     * - type: CorporateIDType
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Identifies the source authority for the code. | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $CodeContext;
    /**
     * The URI
     * Meta information extracted from the WSDL
     * - documentation: Identifies the location of the code table
     * - type: xs:anyURI
     * - use: optional
     * @var string
     */
    public $URI;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for NegotiatedFareCode
     * @uses NegotiatedFareCode::setSupplier()
     * @uses NegotiatedFareCode::setTPA_Extensions()
     * @uses NegotiatedFareCode::setSecondaryCode()
     * @uses NegotiatedFareCode::setSupplierCode()
     * @uses NegotiatedFareCode::setCode()
     * @uses NegotiatedFareCode::setCodeContext()
     * @uses NegotiatedFareCode::setURI()
     * @uses NegotiatedFareCode::setQuantity()
     * @param \SabreSoap\StructType\CompanyNameType[] $supplier
     * @param string $tPA_Extensions
     * @param string $secondaryCode
     * @param string $supplierCode
     * @param string $code
     * @param string $codeContext
     * @param string $uRI
     * @param int $quantity
     */
    public function __construct(array $supplier = array(), $tPA_Extensions = null, $secondaryCode = null, $supplierCode = null, $code = null, $codeContext = null, $uRI = null, $quantity = null)
    {
        $this
            ->setSupplier($supplier)
            ->setTPA_Extensions($tPA_Extensions)
            ->setSecondaryCode($secondaryCode)
            ->setSupplierCode($supplierCode)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setURI($uRI)
            ->setQuantity($quantity);
    }
    /**
     * Get Supplier value
     * @return \SabreSoap\StructType\CompanyNameType[]|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \SabreSoap\StructType\CompanyNameType[] $supplier
     * @return \SabreSoap\StructType\NegotiatedFareCode
     */
    public function setSupplier(array $supplier = array())
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Add item to Supplier value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\CompanyNameType $item
     * @return \SabreSoap\StructType\NegotiatedFareCode
     */
    public function addToSupplier(\SabreSoap\StructType\CompanyNameType $item)
    {
        $this->Supplier[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return string|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param string $tPA_Extensions
     * @return \SabreSoap\StructType\NegotiatedFareCode
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get SecondaryCode value
     * @return string|null
     */
    public function getSecondaryCode()
    {
        return $this->SecondaryCode;
    }
    /**
     * Set SecondaryCode value
     * @param string $secondaryCode
     * @return \SabreSoap\StructType\NegotiatedFareCode
     */
    public function setSecondaryCode($secondaryCode = null)
    {
        $this->SecondaryCode = $secondaryCode;
        return $this;
    }
    /**
     * Get SupplierCode value
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param string $supplierCode
     * @return \SabreSoap\StructType\NegotiatedFareCode
     */
    public function setSupplierCode($supplierCode = null)
    {
        $this->SupplierCode = $supplierCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \SabreSoap\StructType\NegotiatedFareCode
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \SabreSoap\StructType\NegotiatedFareCode
     */
    public function setCodeContext($codeContext = null)
    {
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \SabreSoap\StructType\NegotiatedFareCode
     */
    public function setURI($uRI = null)
    {
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \SabreSoap\StructType\NegotiatedFareCode
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
}
