<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Envelope StructType
 * Meta information extracted from the WSDL
 * - type: tns:Envelope
 * @subpackage Structs
 */
class Envelope extends AbstractStructBase
{
    /**
     * The Header
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Header
     * @var \SabreSoap\StructType\Header[]
     */
    public $Header;
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - ref: tns:Body
     * @var \SabreSoap\StructType\Body
     */
    public $Body;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for Envelope
     * @uses Envelope::setHeader()
     * @uses Envelope::setBody()
     * @uses Envelope::setAny()
     * @param \SabreSoap\StructType\Header[] $header
     * @param \SabreSoap\StructType\Body $body
     * @param \DOMDocument $any
     */
    public function __construct(array $header = array(), \SabreSoap\StructType\Body $body = null, \DOMDocument $any = null)
    {
        $this
            ->setHeader($header)
            ->setBody($body)
            ->setAny($any);
    }
    /**
     * Get Header value
     * @return \SabreSoap\StructType\Header[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @param \SabreSoap\StructType\Header[] $header
     * @return \SabreSoap\StructType\Envelope
     */
    public function setHeader(array $header = array())
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Header $item
     * @return \SabreSoap\StructType\Envelope
     */
    public function addToHeader(\SabreSoap\StructType\Header $item)
    {
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Get Body value
     * @return \SabreSoap\StructType\Body|null
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param \SabreSoap\StructType\Body $body
     * @return \SabreSoap\StructType\Envelope
     */
    public function setBody(\SabreSoap\StructType\Body $body = null)
    {
        $this->Body = $body;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\Envelope
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
