<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SabreAth StructType
 * Meta information extracted from the WSDL
 * - documentation: Sabre authentication ID (ATH) - passed into the request to keep session information when communicating with TPF. The use of this element had been deprecated and is achieved by session pooling mechanism in Intellisell.
 * @subpackage Structs
 */
class SabreAth extends AbstractStructBase
{
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * The BinarySecToken
     * @var string
     */
    public $BinarySecToken;
    /**
     * The ConversationID
     * @var string
     */
    public $ConversationID;
    /**
     * Constructor method for SabreAth
     * @uses SabreAth::setValue()
     * @uses SabreAth::setBinarySecToken()
     * @uses SabreAth::setConversationID()
     * @param string $value
     * @param string $binarySecToken
     * @param string $conversationID
     */
    public function __construct($value = null, $binarySecToken = null, $conversationID = null)
    {
        $this
            ->setValue($value)
            ->setBinarySecToken($binarySecToken)
            ->setConversationID($conversationID);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \SabreSoap\StructType\SabreAth
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get BinarySecToken value
     * @return string|null
     */
    public function getBinarySecToken()
    {
        return $this->BinarySecToken;
    }
    /**
     * Set BinarySecToken value
     * @param string $binarySecToken
     * @return \SabreSoap\StructType\SabreAth
     */
    public function setBinarySecToken($binarySecToken = null)
    {
        $this->BinarySecToken = $binarySecToken;
        return $this;
    }
    /**
     * Get ConversationID value
     * @return string|null
     */
    public function getConversationID()
    {
        return $this->ConversationID;
    }
    /**
     * Set ConversationID value
     * @param string $conversationID
     * @return \SabreSoap\StructType\SabreAth
     */
    public function setConversationID($conversationID = null)
    {
        $this->ConversationID = $conversationID;
        return $this;
    }
}
