<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Override StructType
 * @subpackage Structs
 */
class Override extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9A-Z]{2,3}
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [1-9][0-9]*|0%?|100%|[1-9][0-9]?%
     * - use: required
     * @var string
     */
    public $Options;
    /**
     * Constructor method for Override
     * @uses Override::setCode()
     * @uses Override::setOptions()
     * @param string $code
     * @param string $options
     */
    public function __construct($code = null, $options = null)
    {
        $this
            ->setCode($code)
            ->setOptions($options);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \SabreSoap\StructType\Override
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Options value
     * @return string
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param string $options
     * @return \SabreSoap\StructType\Override
     */
    public function setOptions($options = null)
    {
        $this->Options = $options;
        return $this;
    }
}
