<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareParameters StructType
 * Meta information extracted from the WSDL
 * - documentation: This element specifies parameters for desired fare.
 * @subpackage Structs
 */
class FareParameters extends AbstractStructBase
{
    /**
     * The ExcludeRestricted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ExcludeRestricted
     */
    public $ExcludeRestricted;
    /**
     * The ResTicketing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ResTicketing
     */
    public $ResTicketing;
    /**
     * The MinMaxStay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\MinMaxStay
     */
    public $MinMaxStay;
    /**
     * The RefundPenalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\RefundPenalty
     */
    public $RefundPenalty;
    /**
     * The PublicFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PublicFare
     */
    public $PublicFare;
    /**
     * The PrivateFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PrivateFare
     */
    public $PrivateFare;
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Cabin
     */
    public $Cabin;
    /**
     * The PassengerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PassengerType
     */
    public $PassengerType;
    /**
     * The CorporateID
     * Meta information extracted from the WSDL
     * - choice: CorporateID | AccountCode
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CorporateID
     */
    public $CorporateID;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - choice: CorporateID | AccountCode
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AccountCode
     */
    public $AccountCode;
    /**
     * Constructor method for FareParameters
     * @uses FareParameters::setExcludeRestricted()
     * @uses FareParameters::setResTicketing()
     * @uses FareParameters::setMinMaxStay()
     * @uses FareParameters::setRefundPenalty()
     * @uses FareParameters::setPublicFare()
     * @uses FareParameters::setPrivateFare()
     * @uses FareParameters::setCabin()
     * @uses FareParameters::setPassengerType()
     * @uses FareParameters::setCorporateID()
     * @uses FareParameters::setAccountCode()
     * @param \SabreSoap\StructType\ExcludeRestricted $excludeRestricted
     * @param \SabreSoap\StructType\ResTicketing $resTicketing
     * @param \SabreSoap\StructType\MinMaxStay $minMaxStay
     * @param \SabreSoap\StructType\RefundPenalty $refundPenalty
     * @param \SabreSoap\StructType\PublicFare $publicFare
     * @param \SabreSoap\StructType\PrivateFare $privateFare
     * @param \SabreSoap\StructType\Cabin $cabin
     * @param \SabreSoap\StructType\PassengerType $passengerType
     * @param \SabreSoap\StructType\CorporateID $corporateID
     * @param \SabreSoap\StructType\AccountCode $accountCode
     */
    public function __construct(\SabreSoap\StructType\ExcludeRestricted $excludeRestricted = null, \SabreSoap\StructType\ResTicketing $resTicketing = null, \SabreSoap\StructType\MinMaxStay $minMaxStay = null, \SabreSoap\StructType\RefundPenalty $refundPenalty = null, \SabreSoap\StructType\PublicFare $publicFare = null, \SabreSoap\StructType\PrivateFare $privateFare = null, \SabreSoap\StructType\Cabin $cabin = null, \SabreSoap\StructType\PassengerType $passengerType = null, \SabreSoap\StructType\CorporateID $corporateID = null, \SabreSoap\StructType\AccountCode $accountCode = null)
    {
        $this
            ->setExcludeRestricted($excludeRestricted)
            ->setResTicketing($resTicketing)
            ->setMinMaxStay($minMaxStay)
            ->setRefundPenalty($refundPenalty)
            ->setPublicFare($publicFare)
            ->setPrivateFare($privateFare)
            ->setCabin($cabin)
            ->setPassengerType($passengerType)
            ->setCorporateID($corporateID)
            ->setAccountCode($accountCode);
    }
    /**
     * Get ExcludeRestricted value
     * @return \SabreSoap\StructType\ExcludeRestricted|null
     */
    public function getExcludeRestricted()
    {
        return $this->ExcludeRestricted;
    }
    /**
     * Set ExcludeRestricted value
     * @param \SabreSoap\StructType\ExcludeRestricted $excludeRestricted
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setExcludeRestricted(\SabreSoap\StructType\ExcludeRestricted $excludeRestricted = null)
    {
        $this->ExcludeRestricted = $excludeRestricted;
        return $this;
    }
    /**
     * Get ResTicketing value
     * @return \SabreSoap\StructType\ResTicketing|null
     */
    public function getResTicketing()
    {
        return $this->ResTicketing;
    }
    /**
     * Set ResTicketing value
     * @param \SabreSoap\StructType\ResTicketing $resTicketing
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setResTicketing(\SabreSoap\StructType\ResTicketing $resTicketing = null)
    {
        $this->ResTicketing = $resTicketing;
        return $this;
    }
    /**
     * Get MinMaxStay value
     * @return \SabreSoap\StructType\MinMaxStay|null
     */
    public function getMinMaxStay()
    {
        return $this->MinMaxStay;
    }
    /**
     * Set MinMaxStay value
     * @param \SabreSoap\StructType\MinMaxStay $minMaxStay
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setMinMaxStay(\SabreSoap\StructType\MinMaxStay $minMaxStay = null)
    {
        $this->MinMaxStay = $minMaxStay;
        return $this;
    }
    /**
     * Get RefundPenalty value
     * @return \SabreSoap\StructType\RefundPenalty|null
     */
    public function getRefundPenalty()
    {
        return $this->RefundPenalty;
    }
    /**
     * Set RefundPenalty value
     * @param \SabreSoap\StructType\RefundPenalty $refundPenalty
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setRefundPenalty(\SabreSoap\StructType\RefundPenalty $refundPenalty = null)
    {
        $this->RefundPenalty = $refundPenalty;
        return $this;
    }
    /**
     * Get PublicFare value
     * @return \SabreSoap\StructType\PublicFare|null
     */
    public function getPublicFare()
    {
        return $this->PublicFare;
    }
    /**
     * Set PublicFare value
     * @param \SabreSoap\StructType\PublicFare $publicFare
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setPublicFare(\SabreSoap\StructType\PublicFare $publicFare = null)
    {
        $this->PublicFare = $publicFare;
        return $this;
    }
    /**
     * Get PrivateFare value
     * @return \SabreSoap\StructType\PrivateFare|null
     */
    public function getPrivateFare()
    {
        return $this->PrivateFare;
    }
    /**
     * Set PrivateFare value
     * @param \SabreSoap\StructType\PrivateFare $privateFare
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setPrivateFare(\SabreSoap\StructType\PrivateFare $privateFare = null)
    {
        $this->PrivateFare = $privateFare;
        return $this;
    }
    /**
     * Get Cabin value
     * @return \SabreSoap\StructType\Cabin|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param \SabreSoap\StructType\Cabin $cabin
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setCabin(\SabreSoap\StructType\Cabin $cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return \SabreSoap\StructType\PassengerType|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param \SabreSoap\StructType\PassengerType $passengerType
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setPassengerType(\SabreSoap\StructType\PassengerType $passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get CorporateID value
     * @return \SabreSoap\StructType\CorporateID|null
     */
    public function getCorporateID()
    {
        return isset($this->CorporateID) ? $this->CorporateID : null;
    }
    /**
     * Set CorporateID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\CorporateID $corporateID
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setCorporateID(\SabreSoap\StructType\CorporateID $corporateID = null)
    {
        if (is_null($corporateID) || (is_array($corporateID) && empty($corporateID))) {
            unset($this->CorporateID);
        } else {
            $this->CorporateID = $corporateID;
        }
        return $this;
    }
    /**
     * Get AccountCode value
     * @return \SabreSoap\StructType\AccountCode|null
     */
    public function getAccountCode()
    {
        return isset($this->AccountCode) ? $this->AccountCode : null;
    }
    /**
     * Set AccountCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\AccountCode $accountCode
     * @return \SabreSoap\StructType\FareParameters
     */
    public function setAccountCode(\SabreSoap\StructType\AccountCode $accountCode = null)
    {
        if (is_null($accountCode) || (is_array($accountCode) && empty($accountCode))) {
            unset($this->AccountCode);
        } else {
            $this->AccountCode = $accountCode;
        }
        return $this;
    }
}
