<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security StructType
 * Meta information extracted from the WSDL
 * - Prefix: wsse
 * @subpackage Structs
 */
class Security extends AbstractStructBase
{
    /**
     * The UsernameToken
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var \SabreSoap\StructType\UsernameToken
     */
    public $UsernameToken;
    /**
     * The SabreAth
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $SabreAth;
    /**
     * The BinarySecurityToken
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $BinarySecurityToken;
    /**
     * Constructor method for Security
     * @uses Security::setUsernameToken()
     * @uses Security::setSabreAth()
     * @uses Security::setBinarySecurityToken()
     * @param \SabreSoap\StructType\UsernameToken $usernameToken
     * @param string $sabreAth
     * @param string $binarySecurityToken
     */
    public function __construct(\SabreSoap\StructType\UsernameToken $usernameToken = null, $sabreAth = null, $binarySecurityToken = null)
    {
        $this
            ->setUsernameToken($usernameToken)
            ->setSabreAth($sabreAth)
            ->setBinarySecurityToken($binarySecurityToken);
    }
    /**
     * Get UsernameToken value
     * @return \SabreSoap\StructType\UsernameToken|null
     */
    public function getUsernameToken()
    {
        return $this->UsernameToken;
    }
    /**
     * Set UsernameToken value
     * @param \SabreSoap\StructType\UsernameToken $usernameToken
     * @return \SabreSoap\StructType\Security
     */
    public function setUsernameToken(\SabreSoap\StructType\UsernameToken $usernameToken = null)
    {
        $this->UsernameToken = $usernameToken;
        return $this;
    }
    /**
     * Get SabreAth value
     * @return string|null
     */
    public function getSabreAth()
    {
        return $this->SabreAth;
    }
    /**
     * Set SabreAth value
     * @param string $sabreAth
     * @return \SabreSoap\StructType\Security
     */
    public function setSabreAth($sabreAth = null)
    {
        $this->SabreAth = $sabreAth;
        return $this;
    }
    /**
     * Get BinarySecurityToken value
     * @return string|null
     */
    public function getBinarySecurityToken()
    {
        return $this->BinarySecurityToken;
    }
    /**
     * Set BinarySecurityToken value
     * @param string $binarySecurityToken
     * @return \SabreSoap\StructType\Security
     */
    public function setBinarySecurityToken($binarySecurityToken = null)
    {
        $this->BinarySecurityToken = $binarySecurityToken;
        return $this;
    }
}
