<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvTicketing StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies advance ticketing restrictions.
 * @subpackage Structs
 */
class AdvTicketing extends AbstractStructBase
{
    /**
     * The FromResTimeOfDay
     * Meta information extracted from the WSDL
     * - documentation: The time of day after reservations are made by which a ticket must be purchased. | Allows for the specification of a date time or just time.
     * - union: string | time
     * - use: optional
     * @var string
     */
    public $FromResTimeOfDay;
    /**
     * The FromResPeriod
     * Meta information extracted from the WSDL
     * - documentation: A length of time expressed as either an amount of time or the number of occurrences of a day of the week after reservations are made that a ticket must be purchased. | Used for Numeric Strings, minimum length 1, maximum length 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - use: optional
     * @var string
     */
    public $FromResPeriod;
    /**
     * The FromResUnit
     * Meta information extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week to be applied to the period after reservation are made that a ticket must be purchased.
     * - use: optional
     * @var string
     */
    public $FromResUnit;
    /**
     * The FromDepartTimeOfDay
     * Meta information extracted from the WSDL
     * - documentation: The time of day prior to departure when the ticket must be purchased. | Allows for the specification of a date time or just time.
     * - union: string | time
     * - use: optional
     * @var string
     */
    public $FromDepartTimeOfDay;
    /**
     * The FromDepartPeriod
     * Meta information extracted from the WSDL
     * - documentation: A length of time expressed as either an amount of time or the number of occurrences of a day of the week before departure that a ticket must be purchased. | Used for Numeric Strings, minimum length 1, maximum length 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - use: optional
     * @var string
     */
    public $FromDepartPeriod;
    /**
     * The FromDepartUnit
     * Meta information extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week to be applied to the the period before departure that a ticket must be purchased.
     * - use: optional
     * @var string
     */
    public $FromDepartUnit;
    /**
     * Constructor method for AdvTicketing
     * @uses AdvTicketing::setFromResTimeOfDay()
     * @uses AdvTicketing::setFromResPeriod()
     * @uses AdvTicketing::setFromResUnit()
     * @uses AdvTicketing::setFromDepartTimeOfDay()
     * @uses AdvTicketing::setFromDepartPeriod()
     * @uses AdvTicketing::setFromDepartUnit()
     * @param string $fromResTimeOfDay
     * @param string $fromResPeriod
     * @param string $fromResUnit
     * @param string $fromDepartTimeOfDay
     * @param string $fromDepartPeriod
     * @param string $fromDepartUnit
     */
    public function __construct($fromResTimeOfDay = null, $fromResPeriod = null, $fromResUnit = null, $fromDepartTimeOfDay = null, $fromDepartPeriod = null, $fromDepartUnit = null)
    {
        $this
            ->setFromResTimeOfDay($fromResTimeOfDay)
            ->setFromResPeriod($fromResPeriod)
            ->setFromResUnit($fromResUnit)
            ->setFromDepartTimeOfDay($fromDepartTimeOfDay)
            ->setFromDepartPeriod($fromDepartPeriod)
            ->setFromDepartUnit($fromDepartUnit);
    }
    /**
     * Get FromResTimeOfDay value
     * @return string|null
     */
    public function getFromResTimeOfDay()
    {
        return $this->FromResTimeOfDay;
    }
    /**
     * Set FromResTimeOfDay value
     * @param string $fromResTimeOfDay
     * @return \SabreSoap\StructType\AdvTicketing
     */
    public function setFromResTimeOfDay($fromResTimeOfDay = null)
    {
        $this->FromResTimeOfDay = $fromResTimeOfDay;
        return $this;
    }
    /**
     * Get FromResPeriod value
     * @return string|null
     */
    public function getFromResPeriod()
    {
        return $this->FromResPeriod;
    }
    /**
     * Set FromResPeriod value
     * @param string $fromResPeriod
     * @return \SabreSoap\StructType\AdvTicketing
     */
    public function setFromResPeriod($fromResPeriod = null)
    {
        $this->FromResPeriod = $fromResPeriod;
        return $this;
    }
    /**
     * Get FromResUnit value
     * @return string|null
     */
    public function getFromResUnit()
    {
        return $this->FromResUnit;
    }
    /**
     * Set FromResUnit value
     * @param string $fromResUnit
     * @return \SabreSoap\StructType\AdvTicketing
     */
    public function setFromResUnit($fromResUnit = null)
    {
        $this->FromResUnit = $fromResUnit;
        return $this;
    }
    /**
     * Get FromDepartTimeOfDay value
     * @return string|null
     */
    public function getFromDepartTimeOfDay()
    {
        return $this->FromDepartTimeOfDay;
    }
    /**
     * Set FromDepartTimeOfDay value
     * @param string $fromDepartTimeOfDay
     * @return \SabreSoap\StructType\AdvTicketing
     */
    public function setFromDepartTimeOfDay($fromDepartTimeOfDay = null)
    {
        $this->FromDepartTimeOfDay = $fromDepartTimeOfDay;
        return $this;
    }
    /**
     * Get FromDepartPeriod value
     * @return string|null
     */
    public function getFromDepartPeriod()
    {
        return $this->FromDepartPeriod;
    }
    /**
     * Set FromDepartPeriod value
     * @param string $fromDepartPeriod
     * @return \SabreSoap\StructType\AdvTicketing
     */
    public function setFromDepartPeriod($fromDepartPeriod = null)
    {
        $this->FromDepartPeriod = $fromDepartPeriod;
        return $this;
    }
    /**
     * Get FromDepartUnit value
     * @return string|null
     */
    public function getFromDepartUnit()
    {
        return $this->FromDepartUnit;
    }
    /**
     * Set FromDepartUnit value
     * @param string $fromDepartUnit
     * @return \SabreSoap\StructType\AdvTicketing
     */
    public function setFromDepartUnit($fromDepartUnit = null)
    {
        $this->FromDepartUnit = $fromDepartUnit;
        return $this;
    }
}
