<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignedInfoType StructType
 * @subpackage Structs
 */
class SignedInfoType extends AbstractStructBase
{
    /**
     * The CanonicalizationMethod
     * Meta information extracted from the WSDL
     * - ref: ds:CanonicalizationMethod
     * @var \SabreSoap\StructType\CanonicalizationMethodType
     */
    public $CanonicalizationMethod;
    /**
     * The SignatureMethod
     * Meta information extracted from the WSDL
     * - ref: ds:SignatureMethod
     * @var \SabreSoap\StructType\SignatureMethodType
     */
    public $SignatureMethod;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:Reference
     * @var \SabreSoap\StructType\ReferenceType[]
     */
    public $Reference;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignedInfoType
     * @uses SignedInfoType::setCanonicalizationMethod()
     * @uses SignedInfoType::setSignatureMethod()
     * @uses SignedInfoType::setReference()
     * @uses SignedInfoType::setId()
     * @param \SabreSoap\StructType\CanonicalizationMethodType $canonicalizationMethod
     * @param \SabreSoap\StructType\SignatureMethodType $signatureMethod
     * @param \SabreSoap\StructType\ReferenceType[] $reference
     * @param string $id
     */
    public function __construct(\SabreSoap\StructType\CanonicalizationMethodType $canonicalizationMethod = null, \SabreSoap\StructType\SignatureMethodType $signatureMethod = null, array $reference = array(), $id = null)
    {
        $this
            ->setCanonicalizationMethod($canonicalizationMethod)
            ->setSignatureMethod($signatureMethod)
            ->setReference($reference)
            ->setId($id);
    }
    /**
     * Get CanonicalizationMethod value
     * @return \SabreSoap\StructType\CanonicalizationMethodType|null
     */
    public function getCanonicalizationMethod()
    {
        return $this->CanonicalizationMethod;
    }
    /**
     * Set CanonicalizationMethod value
     * @param \SabreSoap\StructType\CanonicalizationMethodType $canonicalizationMethod
     * @return \SabreSoap\StructType\SignedInfoType
     */
    public function setCanonicalizationMethod(\SabreSoap\StructType\CanonicalizationMethodType $canonicalizationMethod = null)
    {
        $this->CanonicalizationMethod = $canonicalizationMethod;
        return $this;
    }
    /**
     * Get SignatureMethod value
     * @return \SabreSoap\StructType\SignatureMethodType|null
     */
    public function getSignatureMethod()
    {
        return $this->SignatureMethod;
    }
    /**
     * Set SignatureMethod value
     * @param \SabreSoap\StructType\SignatureMethodType $signatureMethod
     * @return \SabreSoap\StructType\SignedInfoType
     */
    public function setSignatureMethod(\SabreSoap\StructType\SignatureMethodType $signatureMethod = null)
    {
        $this->SignatureMethod = $signatureMethod;
        return $this;
    }
    /**
     * Get Reference value
     * @return \SabreSoap\StructType\ReferenceType[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \SabreSoap\StructType\ReferenceType[] $reference
     * @return \SabreSoap\StructType\SignedInfoType
     */
    public function setReference(array $reference = array())
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\ReferenceType $item
     * @return \SabreSoap\StructType\SignedInfoType
     */
    public function addToReference(\SabreSoap\StructType\ReferenceType $item)
    {
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabreSoap\StructType\SignedInfoType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
}
