<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirSearchPrefsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request smoking flights in response. Defaults to false - no desire for smoking flights. | Defines user preferences to be used in conducting a search.
 * @subpackage Structs
 */
class AirSearchPrefsType extends AbstractStructBase
{
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - documentation: Specify vendors to include and exclude from the response.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The FlightTypePref
     * Meta information extracted from the WSDL
     * - documentation: Defines preferred flight characteristics to be used in a search.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FlightTypePrefType
     */
    public $FlightTypePref;
    /**
     * The FareRestrictPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The EquipPref
     * Meta information extracted from the WSDL
     * - documentation: Defines preferred equipment profile(s) to be used in a search.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \SabreSoap\StructType\EquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The CabinPref
     * Meta information extracted from the WSDL
     * - documentation: Defines preferred cabin(s) to be used in a search. The Cabin type specified in a OriginDestinationInformation/TPA_Extensions overrides this Cabin type for that specific segment/leg. If a Cabin type is not specified in a
     * OriginDestinationInformation/TPA_Extensions the cabin type in this element will be used as default cabin type for that segment/leg.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CabinPrefType[]
     */
    public $CabinPref;
    /**
     * The TicketDistribPref
     * Meta information extracted from the WSDL
     * - documentation: Defines Distribution prefernces.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TicketDistribPrefType[]
     */
    public $TicketDistribPref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The AncillaryFees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AncillaryFees
     */
    public $AncillaryFees;
    /**
     * The SpanishFamilyDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SpanishFamilyDiscount
     */
    public $SpanishFamilyDiscount;
    /**
     * The OnTimeRate
     * Meta information extracted from the WSDL
     * - documentation: Request for flights in response that meet the given Department of Transport on-time rate. This is a number between 0 and 100. | Used for percentage values
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.01
     * - use: optional
     * @var float
     */
    public $OnTimeRate;
    /**
     * The ETicketDesired
     * Meta information extracted from the WSDL
     * - documentation: Request flights that are e-ticketable in the response.
     * - default: false
     * - use: optional
     * @var bool
     */
    public $ETicketDesired;
    /**
     * The ValidInterlineTicket
     * Meta information extracted from the WSDL
     * - documentation: Request options that are validated on base of interline ticketing aggrement.
     * - default: false
     * - use: optional
     * @var bool
     */
    public $ValidInterlineTicket;
    /**
     * The MaxStopsQuantity
     * Meta information extracted from the WSDL
     * - documentation: Request flights that have no more than the requested number of stops. | Used for Numeric values, from 0 to 999 inclusive
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $MaxStopsQuantity;
    /**
     * The AllFlightsData
     * Meta information extracted from the WSDL
     * - documentation: Return flights not combinable into roundtrips as one ways is a separate section.
     * - default: false
     * - use: optional
     * @var bool
     */
    public $AllFlightsData;
    /**
     * The SmokingAllowed
     * Meta information extracted from the WSDL
     * - default: false
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * Constructor method for AirSearchPrefsType
     * @uses AirSearchPrefsType::setVendorPref()
     * @uses AirSearchPrefsType::setFlightTypePref()
     * @uses AirSearchPrefsType::setFareRestrictPref()
     * @uses AirSearchPrefsType::setEquipPref()
     * @uses AirSearchPrefsType::setCabinPref()
     * @uses AirSearchPrefsType::setTicketDistribPref()
     * @uses AirSearchPrefsType::setTPA_Extensions()
     * @uses AirSearchPrefsType::setAncillaryFees()
     * @uses AirSearchPrefsType::setSpanishFamilyDiscount()
     * @uses AirSearchPrefsType::setOnTimeRate()
     * @uses AirSearchPrefsType::setETicketDesired()
     * @uses AirSearchPrefsType::setValidInterlineTicket()
     * @uses AirSearchPrefsType::setMaxStopsQuantity()
     * @uses AirSearchPrefsType::setAllFlightsData()
     * @uses AirSearchPrefsType::setSmokingAllowed()
     * @param \SabreSoap\StructType\CompanyNamePrefType[] $vendorPref
     * @param \SabreSoap\StructType\FlightTypePrefType $flightTypePref
     * @param \SabreSoap\StructType\FareRestrictPref[] $fareRestrictPref
     * @param \SabreSoap\StructType\EquipmentTypePref[] $equipPref
     * @param \SabreSoap\StructType\CabinPrefType[] $cabinPref
     * @param \SabreSoap\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param \SabreSoap\StructType\AncillaryFees $ancillaryFees
     * @param \SabreSoap\StructType\SpanishFamilyDiscount $spanishFamilyDiscount
     * @param float $onTimeRate
     * @param bool $eTicketDesired
     * @param bool $validInterlineTicket
     * @param int $maxStopsQuantity
     * @param bool $allFlightsData
     * @param bool $smokingAllowed
     */
    public function __construct(array $vendorPref = array(), \SabreSoap\StructType\FlightTypePrefType $flightTypePref = null, array $fareRestrictPref = array(), array $equipPref = array(), array $cabinPref = array(), array $ticketDistribPref = array(), \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, \SabreSoap\StructType\AncillaryFees $ancillaryFees = null, \SabreSoap\StructType\SpanishFamilyDiscount $spanishFamilyDiscount = null, $onTimeRate = null, $eTicketDesired = false, $validInterlineTicket = false, $maxStopsQuantity = null, $allFlightsData = false, $smokingAllowed = false)
    {
        $this
            ->setVendorPref($vendorPref)
            ->setFlightTypePref($flightTypePref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setEquipPref($equipPref)
            ->setCabinPref($cabinPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setAncillaryFees($ancillaryFees)
            ->setSpanishFamilyDiscount($spanishFamilyDiscount)
            ->setOnTimeRate($onTimeRate)
            ->setETicketDesired($eTicketDesired)
            ->setValidInterlineTicket($validInterlineTicket)
            ->setMaxStopsQuantity($maxStopsQuantity)
            ->setAllFlightsData($allFlightsData)
            ->setSmokingAllowed($smokingAllowed);
    }
    /**
     * Get VendorPref value
     * @return \SabreSoap\StructType\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @param \SabreSoap\StructType\CompanyNamePrefType[] $vendorPref
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\CompanyNamePrefType $item
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function addToVendorPref(\SabreSoap\StructType\CompanyNamePrefType $item)
    {
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \SabreSoap\StructType\FlightTypePrefType|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * Set FlightTypePref value
     * @param \SabreSoap\StructType\FlightTypePrefType $flightTypePref
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setFlightTypePref(\SabreSoap\StructType\FlightTypePrefType $flightTypePref = null)
    {
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \SabreSoap\StructType\FareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * Set FareRestrictPref value
     * @param \SabreSoap\StructType\FareRestrictPref[] $fareRestrictPref
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\FareRestrictPref $item
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function addToFareRestrictPref(\SabreSoap\StructType\FareRestrictPref $item)
    {
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \SabreSoap\StructType\EquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * Set EquipPref value
     * @param \SabreSoap\StructType\EquipmentTypePref[] $equipPref
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setEquipPref(array $equipPref = array())
    {
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\EquipmentTypePref $item
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function addToEquipPref(\SabreSoap\StructType\EquipmentTypePref $item)
    {
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \SabreSoap\StructType\CabinPrefType[]|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * Set CabinPref value
     * @param \SabreSoap\StructType\CabinPrefType[] $cabinPref
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setCabinPref(array $cabinPref = array())
    {
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Add item to CabinPref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\CabinPrefType $item
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function addToCabinPref(\SabreSoap\StructType\CabinPrefType $item)
    {
        $this->CabinPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \SabreSoap\StructType\TicketDistribPrefType[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * Set TicketDistribPref value
     * @param \SabreSoap\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\TicketDistribPrefType $item
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function addToTicketDistribPref(\SabreSoap\StructType\TicketDistribPrefType $item)
    {
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get AncillaryFees value
     * @return \SabreSoap\StructType\AncillaryFees|null
     */
    public function getAncillaryFees()
    {
        return $this->AncillaryFees;
    }
    /**
     * Set AncillaryFees value
     * @param \SabreSoap\StructType\AncillaryFees $ancillaryFees
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setAncillaryFees(\SabreSoap\StructType\AncillaryFees $ancillaryFees = null)
    {
        $this->AncillaryFees = $ancillaryFees;
        return $this;
    }
    /**
     * Get SpanishFamilyDiscount value
     * @return \SabreSoap\StructType\SpanishFamilyDiscount|null
     */
    public function getSpanishFamilyDiscount()
    {
        return $this->SpanishFamilyDiscount;
    }
    /**
     * Set SpanishFamilyDiscount value
     * @param \SabreSoap\StructType\SpanishFamilyDiscount $spanishFamilyDiscount
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setSpanishFamilyDiscount(\SabreSoap\StructType\SpanishFamilyDiscount $spanishFamilyDiscount = null)
    {
        $this->SpanishFamilyDiscount = $spanishFamilyDiscount;
        return $this;
    }
    /**
     * Get OnTimeRate value
     * @return float|null
     */
    public function getOnTimeRate()
    {
        return $this->OnTimeRate;
    }
    /**
     * Set OnTimeRate value
     * @param float $onTimeRate
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setOnTimeRate($onTimeRate = null)
    {
        $this->OnTimeRate = $onTimeRate;
        return $this;
    }
    /**
     * Get ETicketDesired value
     * @return bool|null
     */
    public function getETicketDesired()
    {
        return $this->ETicketDesired;
    }
    /**
     * Set ETicketDesired value
     * @param bool $eTicketDesired
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setETicketDesired($eTicketDesired = false)
    {
        $this->ETicketDesired = $eTicketDesired;
        return $this;
    }
    /**
     * Get ValidInterlineTicket value
     * @return bool|null
     */
    public function getValidInterlineTicket()
    {
        return $this->ValidInterlineTicket;
    }
    /**
     * Set ValidInterlineTicket value
     * @param bool $validInterlineTicket
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setValidInterlineTicket($validInterlineTicket = false)
    {
        $this->ValidInterlineTicket = $validInterlineTicket;
        return $this;
    }
    /**
     * Get MaxStopsQuantity value
     * @return int|null
     */
    public function getMaxStopsQuantity()
    {
        return $this->MaxStopsQuantity;
    }
    /**
     * Set MaxStopsQuantity value
     * @param int $maxStopsQuantity
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setMaxStopsQuantity($maxStopsQuantity = null)
    {
        $this->MaxStopsQuantity = $maxStopsQuantity;
        return $this;
    }
    /**
     * Get AllFlightsData value
     * @return bool|null
     */
    public function getAllFlightsData()
    {
        return $this->AllFlightsData;
    }
    /**
     * Set AllFlightsData value
     * @param bool $allFlightsData
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setAllFlightsData($allFlightsData = false)
    {
        $this->AllFlightsData = $allFlightsData;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \SabreSoap\StructType\AirSearchPrefsType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
}
