<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfoRS_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Extends TicketingInfoType to provide an eTicketNumber.
 * @subpackage Structs
 */
class TicketingInfoRS_Type extends AbstractStructBase
{
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - documentation: TicketType - Indicates the type of ticket (Paper, eTicket)
     * - use: required
     * @var string
     */
    public $TicketType;
    /**
     * The TicketAdvisory
     * Meta information extracted from the WSDL
     * - documentation: Open text field available for additional ticket information.
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FreeTextType[]
     */
    public $TicketAdvisory;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - documentation: Place holder for additional elements.
     * - minOccurs: 0
     * @var string
     */
    public $TPA_Extensions;
    /**
     * The eTicketNumber
     * Meta information extracted from the WSDL
     * - documentation: If reservation is electronically ticketed at time of booking, this is the field for the eTicket number. | Used forAlpha-Numeric Strings, length 1 to 14
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,14}
     * - use: optional
     * @var string
     */
    public $eTicketNumber;
    /**
     * The TicketTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: TicketTimeLimit - Indicates the ticketing arrangement, and allows for the requirement that an itinerary must be ticketed by a certain date and time.
     * - use: optional
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The ValidInterline
     * Meta information extracted from the WSDL
     * - documentation: ValidInterline - Indicates validation of interline ticketing aggrement, possible values (Yes, No, Unknown), default=unknown
     * - default: Unknown
     * - use: optional
     * @var string
     */
    public $ValidInterline;
    /**
     * Constructor method for TicketingInfoRS_Type
     * @uses TicketingInfoRS_Type::setTicketType()
     * @uses TicketingInfoRS_Type::setTicketAdvisory()
     * @uses TicketingInfoRS_Type::setTPA_Extensions()
     * @uses TicketingInfoRS_Type::setETicketNumber()
     * @uses TicketingInfoRS_Type::setTicketTimeLimit()
     * @uses TicketingInfoRS_Type::setValidInterline()
     * @param string $ticketType
     * @param \SabreSoap\StructType\FreeTextType[] $ticketAdvisory
     * @param string $tPA_Extensions
     * @param string $eTicketNumber
     * @param string $ticketTimeLimit
     * @param string $validInterline
     */
    public function __construct($ticketType = null, array $ticketAdvisory = array(), $tPA_Extensions = null, $eTicketNumber = null, $ticketTimeLimit = null, $validInterline = 'Unknown')
    {
        $this
            ->setTicketType($ticketType)
            ->setTicketAdvisory($ticketAdvisory)
            ->setTPA_Extensions($tPA_Extensions)
            ->setETicketNumber($eTicketNumber)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setValidInterline($validInterline);
    }
    /**
     * Get TicketType value
     * @return string
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @param string $ticketType
     * @return \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public function setTicketType($ticketType = null)
    {
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get TicketAdvisory value
     * @return \SabreSoap\StructType\FreeTextType[]|null
     */
    public function getTicketAdvisory()
    {
        return $this->TicketAdvisory;
    }
    /**
     * Set TicketAdvisory value
     * @param \SabreSoap\StructType\FreeTextType[] $ticketAdvisory
     * @return \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public function setTicketAdvisory(array $ticketAdvisory = array())
    {
        $this->TicketAdvisory = $ticketAdvisory;
        return $this;
    }
    /**
     * Add item to TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\FreeTextType $item
     * @return \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public function addToTicketAdvisory(\SabreSoap\StructType\FreeTextType $item)
    {
        $this->TicketAdvisory[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return string|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param string $tPA_Extensions
     * @return \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get eTicketNumber value
     * @return string|null
     */
    public function getETicketNumber()
    {
        return $this->eTicketNumber;
    }
    /**
     * Set eTicketNumber value
     * @param string $eTicketNumber
     * @return \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        $this->eTicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get ValidInterline value
     * @return string|null
     */
    public function getValidInterline()
    {
        return $this->ValidInterline;
    }
    /**
     * Set ValidInterline value
     * @param string $validInterline
     * @return \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public function setValidInterline($validInterline = 'Unknown')
    {
        $this->ValidInterline = $validInterline;
        return $this;
    }
}
