<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItineraryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Itinerary with pricing information.
 * @subpackage Structs
 */
class PricedItineraryType extends AbstractStructBase
{
    /**
     * The SequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Assigns a number to priced itineraries.
     * - use: required
     * @var int
     */
    public $SequenceNumber;
    /**
     * The AirItinerary
     * Meta information extracted from the WSDL
     * - documentation: Specifies the origin and destination of the traveler.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AirItineraryType
     */
    public $AirItinerary;
    /**
     * The AirItineraryPricingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AirItineraryPricingInfo[]
     */
    public $AirItineraryPricingInfo;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - documentation: Provides for free form descriptive information for the priced itinerary.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FreeTextType[]
     */
    public $Notes;
    /**
     * The TicketingInfo
     * Meta information extracted from the WSDL
     * - documentation: Container for TicketingInfoRS_Type.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public $TicketingInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The isFromCustomPath
     * Meta information extracted from the WSDL
     * - documentation: Indicates if itin come from custom carrier/routing path.
     * - use: optional
     * @var bool
     */
    public $isFromCustomPath;
    /**
     * The OriginDestinationRPH
     * Meta information extracted from the WSDL
     * - documentation: When a PricedItinerary element contains flights and pricing information for a single OriginDestinationPair from the OTA_LowFareSearchRQ message, this RPH attribute identifies that OriginDestinationPair from the RQ. When the
     * PricedItinerary contains flights and pricing information for all OriginDestinationPairs from the OTA_LowFareSearchRQ message, this attribute should not be included. | (Reference Place Holder) - an index code to identify an instance in a collection of
     * like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OriginDestinationRPH;
    /**
     * The CampaignID
     * Meta information extracted from the WSDL
     * - documentation: Program/campaign ID, which the downline clients need to determine which marketing text to display.
     * - use: optional
     * @var string
     */
    public $CampaignID;
    /**
     * The AlternateAirport
     * Meta information extracted from the WSDL
     * - documentation: Alternate airport itineraries indicator
     * - use: optional
     * @var bool
     */
    public $AlternateAirport;
    /**
     * The MultipleTickets
     * Meta information extracted from the WSDL
     * - documentation: Indicates that itinerary should be sold on multiple separate tickets
     * - use: optional
     * @var bool
     */
    public $MultipleTickets;
    /**
     * Constructor method for PricedItineraryType
     * @uses PricedItineraryType::setSequenceNumber()
     * @uses PricedItineraryType::setAirItinerary()
     * @uses PricedItineraryType::setAirItineraryPricingInfo()
     * @uses PricedItineraryType::setNotes()
     * @uses PricedItineraryType::setTicketingInfo()
     * @uses PricedItineraryType::setTPA_Extensions()
     * @uses PricedItineraryType::setIsFromCustomPath()
     * @uses PricedItineraryType::setOriginDestinationRPH()
     * @uses PricedItineraryType::setCampaignID()
     * @uses PricedItineraryType::setAlternateAirport()
     * @uses PricedItineraryType::setMultipleTickets()
     * @param int $sequenceNumber
     * @param \SabreSoap\StructType\AirItineraryType $airItinerary
     * @param \SabreSoap\StructType\AirItineraryPricingInfo[] $airItineraryPricingInfo
     * @param \SabreSoap\StructType\FreeTextType[] $notes
     * @param \SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param bool $isFromCustomPath
     * @param string $originDestinationRPH
     * @param string $campaignID
     * @param bool $alternateAirport
     * @param bool $multipleTickets
     */
    public function __construct($sequenceNumber = null, \SabreSoap\StructType\AirItineraryType $airItinerary = null, array $airItineraryPricingInfo = array(), array $notes = array(), \SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, $isFromCustomPath = null, $originDestinationRPH = null, $campaignID = null, $alternateAirport = null, $multipleTickets = null)
    {
        $this
            ->setSequenceNumber($sequenceNumber)
            ->setAirItinerary($airItinerary)
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setNotes($notes)
            ->setTicketingInfo($ticketingInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setIsFromCustomPath($isFromCustomPath)
            ->setOriginDestinationRPH($originDestinationRPH)
            ->setCampaignID($campaignID)
            ->setAlternateAirport($alternateAirport)
            ->setMultipleTickets($multipleTickets);
    }
    /**
     * Get SequenceNumber value
     * @return int
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param int $sequenceNumber
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get AirItinerary value
     * @return \SabreSoap\StructType\AirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \SabreSoap\StructType\AirItineraryType $airItinerary
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setAirItinerary(\SabreSoap\StructType\AirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \SabreSoap\StructType\AirItineraryPricingInfo[]|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @param \SabreSoap\StructType\AirItineraryPricingInfo[] $airItineraryPricingInfo
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setAirItineraryPricingInfo(array $airItineraryPricingInfo = array())
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Add item to AirItineraryPricingInfo value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AirItineraryPricingInfo $item
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function addToAirItineraryPricingInfo(\SabreSoap\StructType\AirItineraryPricingInfo $item)
    {
        $this->AirItineraryPricingInfo[] = $item;
        return $this;
    }
    /**
     * Get Notes value
     * @return \SabreSoap\StructType\FreeTextType[]|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \SabreSoap\StructType\FreeTextType[] $notes
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setNotes(array $notes = array())
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Add item to Notes value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\FreeTextType $item
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function addToNotes(\SabreSoap\StructType\FreeTextType $item)
    {
        $this->Notes[] = $item;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \SabreSoap\StructType\TicketingInfoRS_Type|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setTicketingInfo(\SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get isFromCustomPath value
     * @return bool|null
     */
    public function getIsFromCustomPath()
    {
        return $this->isFromCustomPath;
    }
    /**
     * Set isFromCustomPath value
     * @param bool $isFromCustomPath
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setIsFromCustomPath($isFromCustomPath = null)
    {
        $this->isFromCustomPath = $isFromCustomPath;
        return $this;
    }
    /**
     * Get OriginDestinationRPH value
     * @return string|null
     */
    public function getOriginDestinationRPH()
    {
        return $this->OriginDestinationRPH;
    }
    /**
     * Set OriginDestinationRPH value
     * @param string $originDestinationRPH
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setOriginDestinationRPH($originDestinationRPH = null)
    {
        $this->OriginDestinationRPH = $originDestinationRPH;
        return $this;
    }
    /**
     * Get CampaignID value
     * @return string|null
     */
    public function getCampaignID()
    {
        return $this->CampaignID;
    }
    /**
     * Set CampaignID value
     * @param string $campaignID
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setCampaignID($campaignID = null)
    {
        $this->CampaignID = $campaignID;
        return $this;
    }
    /**
     * Get AlternateAirport value
     * @return bool|null
     */
    public function getAlternateAirport()
    {
        return $this->AlternateAirport;
    }
    /**
     * Set AlternateAirport value
     * @param bool $alternateAirport
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setAlternateAirport($alternateAirport = null)
    {
        $this->AlternateAirport = $alternateAirport;
        return $this;
    }
    /**
     * Get MultipleTickets value
     * @return bool|null
     */
    public function getMultipleTickets()
    {
        return $this->MultipleTickets;
    }
    /**
     * Set MultipleTickets value
     * @param bool $multipleTickets
     * @return \SabreSoap\StructType\PricedItineraryType
     */
    public function setMultipleTickets($multipleTickets = null)
    {
        $this->MultipleTickets = $multipleTickets;
        return $this;
    }
}
