<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceRequestInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identify pricing source, if negotiated fares are requested and if it is a reprice request.
 * @subpackage Structs
 */
class PriceRequestInformationType extends AbstractStructBase
{
    /**
     * The NegotiatedFareCode
     * Meta information extracted from the WSDL
     * - choice: NegotiatedFareCode | AccountCode
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\NegotiatedFareCode
     */
    public $NegotiatedFareCode;
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - choice: NegotiatedFareCode | AccountCode
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \SabreSoap\StructType\AccountCode
     */
    public $AccountCode;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The FareQualifier
     * @var string
     */
    public $FareQualifier;
    /**
     * The NegotiatedFaresOnly
     * Meta information extracted from the WSDL
     * - documentation: Indicator to identify whether or not the price is applicable only to private fares.
     * - type: xs:boolean
     * @var bool
     */
    public $NegotiatedFaresOnly;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Type of funds preferred for reviewing monetary values, in ISO 4217 codes. | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PricingSource
     * Meta information extracted from the WSDL
     * - documentation: It can be used to indicate whether the fare is public or private.
     * - type: RequestPricingSourceType
     * - use: optional
     * @var string
     */
    public $PricingSource;
    /**
     * The Reprice
     * Meta information extracted from the WSDL
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Reprice;
    /**
     * The ProcessThruFaresOnly
     * Meta information extracted from the WSDL
     * - documentation: Activates processing of thru fares only.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $ProcessThruFaresOnly;
    /**
     * The PurchaseDate
     * Meta information extracted from the WSDL
     * - documentation: Specify purchase date. Fares returned will be based on the purchase date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $PurchaseDate;
    /**
     * The NetFaresUsed
     * Meta information extracted from the WSDL
     * - documentation: Set to true when exchange ticket uses net fare.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $NetFaresUsed;
    /**
     * Constructor method for PriceRequestInformationType
     * @uses PriceRequestInformationType::setNegotiatedFareCode()
     * @uses PriceRequestInformationType::setAccountCode()
     * @uses PriceRequestInformationType::setTPA_Extensions()
     * @uses PriceRequestInformationType::setFareQualifier()
     * @uses PriceRequestInformationType::setNegotiatedFaresOnly()
     * @uses PriceRequestInformationType::setCurrencyCode()
     * @uses PriceRequestInformationType::setPricingSource()
     * @uses PriceRequestInformationType::setReprice()
     * @uses PriceRequestInformationType::setProcessThruFaresOnly()
     * @uses PriceRequestInformationType::setPurchaseDate()
     * @uses PriceRequestInformationType::setNetFaresUsed()
     * @param \SabreSoap\StructType\NegotiatedFareCode $negotiatedFareCode
     * @param \SabreSoap\StructType\AccountCode $accountCode
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param string $fareQualifier
     * @param bool $negotiatedFaresOnly
     * @param string $currencyCode
     * @param string $pricingSource
     * @param bool $reprice
     * @param bool $processThruFaresOnly
     * @param string $purchaseDate
     * @param bool $netFaresUsed
     */
    public function __construct(\SabreSoap\StructType\NegotiatedFareCode $negotiatedFareCode = null, \SabreSoap\StructType\AccountCode $accountCode = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, $fareQualifier = null, $negotiatedFaresOnly = null, $currencyCode = null, $pricingSource = null, $reprice = null, $processThruFaresOnly = null, $purchaseDate = null, $netFaresUsed = null)
    {
        $this
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->setAccountCode($accountCode)
            ->setTPA_Extensions($tPA_Extensions)
            ->setFareQualifier($fareQualifier)
            ->setNegotiatedFaresOnly($negotiatedFaresOnly)
            ->setCurrencyCode($currencyCode)
            ->setPricingSource($pricingSource)
            ->setReprice($reprice)
            ->setProcessThruFaresOnly($processThruFaresOnly)
            ->setPurchaseDate($purchaseDate)
            ->setNetFaresUsed($netFaresUsed);
    }
    /**
     * Get NegotiatedFareCode value
     * @return \SabreSoap\StructType\NegotiatedFareCode|null
     */
    public function getNegotiatedFareCode()
    {
        return isset($this->NegotiatedFareCode) ? $this->NegotiatedFareCode : null;
    }
    /**
     * Set NegotiatedFareCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\NegotiatedFareCode $negotiatedFareCode
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setNegotiatedFareCode(\SabreSoap\StructType\NegotiatedFareCode $negotiatedFareCode = null)
    {
        if (is_null($negotiatedFareCode) || (is_array($negotiatedFareCode) && empty($negotiatedFareCode))) {
            unset($this->NegotiatedFareCode);
        } else {
            $this->NegotiatedFareCode = $negotiatedFareCode;
        }
        return $this;
    }
    /**
     * Get AccountCode value
     * @return \SabreSoap\StructType\AccountCode|null
     */
    public function getAccountCode()
    {
        return isset($this->AccountCode) ? $this->AccountCode : null;
    }
    /**
     * Set AccountCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\AccountCode $accountCode
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setAccountCode(\SabreSoap\StructType\AccountCode $accountCode = null)
    {
        if (is_null($accountCode) || (is_array($accountCode) && empty($accountCode))) {
            unset($this->AccountCode);
        } else {
            $this->AccountCode = $accountCode;
        }
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get FareQualifier value
     * @return string|null
     */
    public function getFareQualifier()
    {
        return $this->FareQualifier;
    }
    /**
     * Set FareQualifier value
     * @param string $fareQualifier
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setFareQualifier($fareQualifier = null)
    {
        $this->FareQualifier = $fareQualifier;
        return $this;
    }
    /**
     * Get NegotiatedFaresOnly value
     * @return bool|null
     */
    public function getNegotiatedFaresOnly()
    {
        return $this->NegotiatedFaresOnly;
    }
    /**
     * Set NegotiatedFaresOnly value
     * @param bool $negotiatedFaresOnly
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setNegotiatedFaresOnly($negotiatedFaresOnly = null)
    {
        $this->NegotiatedFaresOnly = $negotiatedFaresOnly;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get Reprice value
     * @return bool|null
     */
    public function getReprice()
    {
        return $this->Reprice;
    }
    /**
     * Set Reprice value
     * @param bool $reprice
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setReprice($reprice = null)
    {
        $this->Reprice = $reprice;
        return $this;
    }
    /**
     * Get ProcessThruFaresOnly value
     * @return bool|null
     */
    public function getProcessThruFaresOnly()
    {
        return $this->ProcessThruFaresOnly;
    }
    /**
     * Set ProcessThruFaresOnly value
     * @param bool $processThruFaresOnly
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setProcessThruFaresOnly($processThruFaresOnly = null)
    {
        $this->ProcessThruFaresOnly = $processThruFaresOnly;
        return $this;
    }
    /**
     * Get PurchaseDate value
     * @return string|null
     */
    public function getPurchaseDate()
    {
        return $this->PurchaseDate;
    }
    /**
     * Set PurchaseDate value
     * @param string $purchaseDate
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setPurchaseDate($purchaseDate = null)
    {
        $this->PurchaseDate = $purchaseDate;
        return $this;
    }
    /**
     * Get NetFaresUsed value
     * @return bool|null
     */
    public function getNetFaresUsed()
    {
        return $this->NetFaresUsed;
    }
    /**
     * Set NetFaresUsed value
     * @param bool $netFaresUsed
     * @return \SabreSoap\StructType\PriceRequestInformationType
     */
    public function setNetFaresUsed($netFaresUsed = null)
    {
        $this->NetFaresUsed = $netFaresUsed;
        return $this;
    }
}
