<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POS_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Point of Sale (POS) is the details identifying the party or connection channel making the request.
 * @subpackage Structs
 */
class POS_Type extends AbstractStructBase
{
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - documentation: This holds details regarding the requestor. It may be repeated to also accommodate the delivery systems.
     * - maxOccurs: 5
     * @var \SabreSoap\StructType\SourceType[]
     */
    public $Source;
    /**
     * Constructor method for POS_Type
     * @uses POS_Type::setSource()
     * @param \SabreSoap\StructType\SourceType[] $source
     */
    public function __construct(array $source = array())
    {
        $this
            ->setSource($source);
    }
    /**
     * Get Source value
     * @return \SabreSoap\StructType\SourceType[]|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \SabreSoap\StructType\SourceType[] $source
     * @return \SabreSoap\StructType\POS_Type
     */
    public function setSource(array $source = array())
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Add item to Source value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\SourceType $item
     * @return \SabreSoap\StructType\POS_Type
     */
    public function addToSource(\SabreSoap\StructType\SourceType $item)
    {
        $this->Source[] = $item;
        return $this;
    }
}
