<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OCFeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: OC Fee details
 * @subpackage Structs
 */
class OCFeeType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Fee amount | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The OriginAirport
     * Meta information extracted from the WSDL
     * - documentation: Origin airport | Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $OriginAirport;
    /**
     * The DestinationAirport
     * Meta information extracted from the WSDL
     * - documentation: Destination airport | Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $DestinationAirport;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: Operating carrier code | Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $Carrier;
    /**
     * The PassengerCode
     * Meta information extracted from the WSDL
     * - documentation: Ancillary fee code
     * - base: xs:string
     * - pattern: [A-Za-z0-9]{2,3}
     * - use: required
     * @var string
     */
    public $PassengerCode;
    /**
     * The StartSegment
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $StartSegment;
    /**
     * The EndSegment
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $EndSegment;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Fee description
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: Date for this fee.
     * - use: optional
     * @var string
     */
    public $Date;
    /**
     * Constructor method for OCFeeType
     * @uses OCFeeType::setAmount()
     * @uses OCFeeType::setOriginAirport()
     * @uses OCFeeType::setDestinationAirport()
     * @uses OCFeeType::setCarrier()
     * @uses OCFeeType::setPassengerCode()
     * @uses OCFeeType::setStartSegment()
     * @uses OCFeeType::setEndSegment()
     * @uses OCFeeType::setDescription()
     * @uses OCFeeType::setDate()
     * @param float $amount
     * @param string $originAirport
     * @param string $destinationAirport
     * @param string $carrier
     * @param string $passengerCode
     * @param string $startSegment
     * @param string $endSegment
     * @param string $description
     * @param string $date
     */
    public function __construct($amount = null, $originAirport = null, $destinationAirport = null, $carrier = null, $passengerCode = null, $startSegment = null, $endSegment = null, $description = null, $date = null)
    {
        $this
            ->setAmount($amount)
            ->setOriginAirport($originAirport)
            ->setDestinationAirport($destinationAirport)
            ->setCarrier($carrier)
            ->setPassengerCode($passengerCode)
            ->setStartSegment($startSegment)
            ->setEndSegment($endSegment)
            ->setDescription($description)
            ->setDate($date);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SabreSoap\StructType\OCFeeType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get OriginAirport value
     * @return string
     */
    public function getOriginAirport()
    {
        return $this->OriginAirport;
    }
    /**
     * Set OriginAirport value
     * @param string $originAirport
     * @return \SabreSoap\StructType\OCFeeType
     */
    public function setOriginAirport($originAirport = null)
    {
        $this->OriginAirport = $originAirport;
        return $this;
    }
    /**
     * Get DestinationAirport value
     * @return string
     */
    public function getDestinationAirport()
    {
        return $this->DestinationAirport;
    }
    /**
     * Set DestinationAirport value
     * @param string $destinationAirport
     * @return \SabreSoap\StructType\OCFeeType
     */
    public function setDestinationAirport($destinationAirport = null)
    {
        $this->DestinationAirport = $destinationAirport;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \SabreSoap\StructType\OCFeeType
     */
    public function setCarrier($carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get PassengerCode value
     * @return string
     */
    public function getPassengerCode()
    {
        return $this->PassengerCode;
    }
    /**
     * Set PassengerCode value
     * @param string $passengerCode
     * @return \SabreSoap\StructType\OCFeeType
     */
    public function setPassengerCode($passengerCode = null)
    {
        $this->PassengerCode = $passengerCode;
        return $this;
    }
    /**
     * Get StartSegment value
     * @return string
     */
    public function getStartSegment()
    {
        return $this->StartSegment;
    }
    /**
     * Set StartSegment value
     * @param string $startSegment
     * @return \SabreSoap\StructType\OCFeeType
     */
    public function setStartSegment($startSegment = null)
    {
        $this->StartSegment = $startSegment;
        return $this;
    }
    /**
     * Get EndSegment value
     * @return string
     */
    public function getEndSegment()
    {
        return $this->EndSegment;
    }
    /**
     * Set EndSegment value
     * @param string $endSegment
     * @return \SabreSoap\StructType\OCFeeType
     */
    public function setEndSegment($endSegment = null)
    {
        $this->EndSegment = $endSegment;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabreSoap\StructType\OCFeeType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \SabreSoap\StructType\OCFeeType
     */
    public function setDate($date = null)
    {
        $this->Date = $date;
        return $this;
    }
}
