<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LongConnectPoints StructType
 * Meta information extracted from the WSDL
 * - documentation: Minimum and maximum number of connection points (not necessarily long) for Long Connections.
 * @subpackage Structs
 */
class LongConnectPoints extends AbstractStructBase
{
    /**
     * The Min
     * @var int
     */
    public $Min;
    /**
     * The Max
     * @var int
     */
    public $Max;
    /**
     * Constructor method for LongConnectPoints
     * @uses LongConnectPoints::setMin()
     * @uses LongConnectPoints::setMax()
     * @param int $min
     * @param int $max
     */
    public function __construct($min = null, $max = null)
    {
        $this
            ->setMin($min)
            ->setMax($max);
    }
    /**
     * Get Min value
     * @return int|null
     */
    public function getMin()
    {
        return $this->Min;
    }
    /**
     * Set Min value
     * @param int $min
     * @return \SabreSoap\StructType\LongConnectPoints
     */
    public function setMin($min = null)
    {
        $this->Min = $min;
        return $this;
    }
    /**
     * Get Max value
     * @return int|null
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param int $max
     * @return \SabreSoap\StructType\LongConnectPoints
     */
    public function setMax($max = null)
    {
        $this->Max = $max;
        return $this;
    }
}
