<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeOriginDestinationInformationType StructType
 * @subpackage Structs
 */
class ExchangeOriginDestinationInformationType extends OriginDestinationInformationType
{
    /**
     * The Flight
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \SabreSoap\StructType\ExchangeOriginDestinationFlightType[]
     */
    public $Flight;
    /**
     * The DateFlexibility
     * @var \SabreSoap\StructType\DateFlexibility
     */
    public $DateFlexibility;
    /**
     * The SisterDestinationLocation
     * @var \SabreSoap\StructType\RequestLocationType
     */
    public $SisterDestinationLocation;
    /**
     * The SisterDestinationMileage
     * @var \SabreSoap\StructType\SisterDestinationMileage
     */
    public $SisterDestinationMileage;
    /**
     * The SisterOriginLocation
     * @var \SabreSoap\StructType\RequestLocationType
     */
    public $SisterOriginLocation;
    /**
     * The SisterOriginMileage
     * @var \SabreSoap\StructType\SisterOriginMileage
     */
    public $SisterOriginMileage;
    /**
     * The SegmentType
     * @var \SabreSoap\StructType\SegmentType
     */
    public $SegmentType;
    /**
     * The AlternateTime
     * @var \SabreSoap\StructType\AlternateTime
     */
    public $AlternateTime;
    /**
     * The MaxOneWayOptions
     * @var \SabreSoap\StructType\MaxOneWayOptions
     */
    public $MaxOneWayOptions;
    /**
     * The NumOneWayOptions
     * @var \SabreSoap\StructType\NumOneWayOptions
     */
    public $NumOneWayOptions;
    /**
     * The CabinPref
     * @var \SabreSoap\StructType\CabinPrefType
     */
    public $CabinPref;
    /**
     * The ConnectionTime
     * @var \SabreSoap\StructType\ConnectionTime
     */
    public $ConnectionTime;
    /**
     * The TotalTravelTime
     * @var \SabreSoap\StructType\TotalTravelTime
     */
    public $TotalTravelTime;
    /**
     * Constructor method for ExchangeOriginDestinationInformationType
     * @uses ExchangeOriginDestinationInformationType::setFlight()
     * @uses ExchangeOriginDestinationInformationType::setDateFlexibility()
     * @uses ExchangeOriginDestinationInformationType::setSisterDestinationLocation()
     * @uses ExchangeOriginDestinationInformationType::setSisterDestinationMileage()
     * @uses ExchangeOriginDestinationInformationType::setSisterOriginLocation()
     * @uses ExchangeOriginDestinationInformationType::setSisterOriginMileage()
     * @uses ExchangeOriginDestinationInformationType::setSegmentType()
     * @uses ExchangeOriginDestinationInformationType::setAlternateTime()
     * @uses ExchangeOriginDestinationInformationType::setMaxOneWayOptions()
     * @uses ExchangeOriginDestinationInformationType::setNumOneWayOptions()
     * @uses ExchangeOriginDestinationInformationType::setCabinPref()
     * @uses ExchangeOriginDestinationInformationType::setConnectionTime()
     * @uses ExchangeOriginDestinationInformationType::setTotalTravelTime()
     * @param \SabreSoap\StructType\ExchangeOriginDestinationFlightType[] $flight
     * @param \SabreSoap\StructType\DateFlexibility $dateFlexibility
     * @param \SabreSoap\StructType\RequestLocationType $sisterDestinationLocation
     * @param \SabreSoap\StructType\SisterDestinationMileage $sisterDestinationMileage
     * @param \SabreSoap\StructType\RequestLocationType $sisterOriginLocation
     * @param \SabreSoap\StructType\SisterOriginMileage $sisterOriginMileage
     * @param \SabreSoap\StructType\SegmentType $segmentType
     * @param \SabreSoap\StructType\AlternateTime $alternateTime
     * @param \SabreSoap\StructType\MaxOneWayOptions $maxOneWayOptions
     * @param \SabreSoap\StructType\NumOneWayOptions $numOneWayOptions
     * @param \SabreSoap\StructType\CabinPrefType $cabinPref
     * @param \SabreSoap\StructType\ConnectionTime $connectionTime
     * @param \SabreSoap\StructType\TotalTravelTime $totalTravelTime
     */
    public function __construct(array $flight = array(), \SabreSoap\StructType\DateFlexibility $dateFlexibility = null, \SabreSoap\StructType\RequestLocationType $sisterDestinationLocation = null, \SabreSoap\StructType\SisterDestinationMileage $sisterDestinationMileage = null, \SabreSoap\StructType\RequestLocationType $sisterOriginLocation = null, \SabreSoap\StructType\SisterOriginMileage $sisterOriginMileage = null, \SabreSoap\StructType\SegmentType $segmentType = null, \SabreSoap\StructType\AlternateTime $alternateTime = null, \SabreSoap\StructType\MaxOneWayOptions $maxOneWayOptions = null, \SabreSoap\StructType\NumOneWayOptions $numOneWayOptions = null, \SabreSoap\StructType\CabinPrefType $cabinPref = null, \SabreSoap\StructType\ConnectionTime $connectionTime = null, \SabreSoap\StructType\TotalTravelTime $totalTravelTime = null)
    {
        $this
            ->setFlight($flight)
            ->setDateFlexibility($dateFlexibility)
            ->setSisterDestinationLocation($sisterDestinationLocation)
            ->setSisterDestinationMileage($sisterDestinationMileage)
            ->setSisterOriginLocation($sisterOriginLocation)
            ->setSisterOriginMileage($sisterOriginMileage)
            ->setSegmentType($segmentType)
            ->setAlternateTime($alternateTime)
            ->setMaxOneWayOptions($maxOneWayOptions)
            ->setNumOneWayOptions($numOneWayOptions)
            ->setCabinPref($cabinPref)
            ->setConnectionTime($connectionTime)
            ->setTotalTravelTime($totalTravelTime);
    }
    /**
     * Get Flight value
     * @return \SabreSoap\StructType\ExchangeOriginDestinationFlightType[]|null
     */
    public function getFlight()
    {
        return $this->Flight;
    }
    /**
     * Set Flight value
     * @param \SabreSoap\StructType\ExchangeOriginDestinationFlightType[] $flight
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setFlight(array $flight = array())
    {
        $this->Flight = $flight;
        return $this;
    }
    /**
     * Add item to Flight value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\ExchangeOriginDestinationFlightType $item
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function addToFlight(\SabreSoap\StructType\ExchangeOriginDestinationFlightType $item)
    {
        $this->Flight[] = $item;
        return $this;
    }
    /**
     * Get DateFlexibility value
     * @return \SabreSoap\StructType\DateFlexibility|null
     */
    public function getDateFlexibility()
    {
        return $this->DateFlexibility;
    }
    /**
     * Set DateFlexibility value
     * @param \SabreSoap\StructType\DateFlexibility $dateFlexibility
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setDateFlexibility(\SabreSoap\StructType\DateFlexibility $dateFlexibility = null)
    {
        $this->DateFlexibility = $dateFlexibility;
        return $this;
    }
    /**
     * Get SisterDestinationLocation value
     * @return \SabreSoap\StructType\RequestLocationType|null
     */
    public function getSisterDestinationLocation()
    {
        return $this->SisterDestinationLocation;
    }
    /**
     * Set SisterDestinationLocation value
     * @param \SabreSoap\StructType\RequestLocationType $sisterDestinationLocation
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setSisterDestinationLocation(\SabreSoap\StructType\RequestLocationType $sisterDestinationLocation = null)
    {
        $this->SisterDestinationLocation = $sisterDestinationLocation;
        return $this;
    }
    /**
     * Get SisterDestinationMileage value
     * @return \SabreSoap\StructType\SisterDestinationMileage|null
     */
    public function getSisterDestinationMileage()
    {
        return $this->SisterDestinationMileage;
    }
    /**
     * Set SisterDestinationMileage value
     * @param \SabreSoap\StructType\SisterDestinationMileage $sisterDestinationMileage
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setSisterDestinationMileage(\SabreSoap\StructType\SisterDestinationMileage $sisterDestinationMileage = null)
    {
        $this->SisterDestinationMileage = $sisterDestinationMileage;
        return $this;
    }
    /**
     * Get SisterOriginLocation value
     * @return \SabreSoap\StructType\RequestLocationType|null
     */
    public function getSisterOriginLocation()
    {
        return $this->SisterOriginLocation;
    }
    /**
     * Set SisterOriginLocation value
     * @param \SabreSoap\StructType\RequestLocationType $sisterOriginLocation
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setSisterOriginLocation(\SabreSoap\StructType\RequestLocationType $sisterOriginLocation = null)
    {
        $this->SisterOriginLocation = $sisterOriginLocation;
        return $this;
    }
    /**
     * Get SisterOriginMileage value
     * @return \SabreSoap\StructType\SisterOriginMileage|null
     */
    public function getSisterOriginMileage()
    {
        return $this->SisterOriginMileage;
    }
    /**
     * Set SisterOriginMileage value
     * @param \SabreSoap\StructType\SisterOriginMileage $sisterOriginMileage
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setSisterOriginMileage(\SabreSoap\StructType\SisterOriginMileage $sisterOriginMileage = null)
    {
        $this->SisterOriginMileage = $sisterOriginMileage;
        return $this;
    }
    /**
     * Get SegmentType value
     * @return \SabreSoap\StructType\SegmentType|null
     */
    public function getSegmentType()
    {
        return $this->SegmentType;
    }
    /**
     * Set SegmentType value
     * @param \SabreSoap\StructType\SegmentType $segmentType
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setSegmentType(\SabreSoap\StructType\SegmentType $segmentType = null)
    {
        $this->SegmentType = $segmentType;
        return $this;
    }
    /**
     * Get AlternateTime value
     * @return \SabreSoap\StructType\AlternateTime|null
     */
    public function getAlternateTime()
    {
        return $this->AlternateTime;
    }
    /**
     * Set AlternateTime value
     * @param \SabreSoap\StructType\AlternateTime $alternateTime
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setAlternateTime(\SabreSoap\StructType\AlternateTime $alternateTime = null)
    {
        $this->AlternateTime = $alternateTime;
        return $this;
    }
    /**
     * Get MaxOneWayOptions value
     * @return \SabreSoap\StructType\MaxOneWayOptions|null
     */
    public function getMaxOneWayOptions()
    {
        return $this->MaxOneWayOptions;
    }
    /**
     * Set MaxOneWayOptions value
     * @param \SabreSoap\StructType\MaxOneWayOptions $maxOneWayOptions
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setMaxOneWayOptions(\SabreSoap\StructType\MaxOneWayOptions $maxOneWayOptions = null)
    {
        $this->MaxOneWayOptions = $maxOneWayOptions;
        return $this;
    }
    /**
     * Get NumOneWayOptions value
     * @return \SabreSoap\StructType\NumOneWayOptions|null
     */
    public function getNumOneWayOptions()
    {
        return $this->NumOneWayOptions;
    }
    /**
     * Set NumOneWayOptions value
     * @param \SabreSoap\StructType\NumOneWayOptions $numOneWayOptions
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setNumOneWayOptions(\SabreSoap\StructType\NumOneWayOptions $numOneWayOptions = null)
    {
        $this->NumOneWayOptions = $numOneWayOptions;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \SabreSoap\StructType\CabinPrefType|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * Set CabinPref value
     * @param \SabreSoap\StructType\CabinPrefType $cabinPref
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setCabinPref(\SabreSoap\StructType\CabinPrefType $cabinPref = null)
    {
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Get ConnectionTime value
     * @return \SabreSoap\StructType\ConnectionTime|null
     */
    public function getConnectionTime()
    {
        return $this->ConnectionTime;
    }
    /**
     * Set ConnectionTime value
     * @param \SabreSoap\StructType\ConnectionTime $connectionTime
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setConnectionTime(\SabreSoap\StructType\ConnectionTime $connectionTime = null)
    {
        $this->ConnectionTime = $connectionTime;
        return $this;
    }
    /**
     * Get TotalTravelTime value
     * @return \SabreSoap\StructType\TotalTravelTime|null
     */
    public function getTotalTravelTime()
    {
        return $this->TotalTravelTime;
    }
    /**
     * Set TotalTravelTime value
     * @param \SabreSoap\StructType\TotalTravelTime $totalTravelTime
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public function setTotalTravelTime(\SabreSoap\StructType\TotalTravelTime $totalTravelTime = null)
    {
        $this->TotalTravelTime = $totalTravelTime;
        return $this;
    }
}
