<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Day StructType
 * @subpackage Structs
 */
class Day extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: IntelliSell Date type (required format: YYYY-MM-DD)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * - use: required
     * @var string
     */
    public $Date;
    /**
     * Constructor method for Day
     * @uses Day::setDate()
     * @param string $date
     */
    public function __construct($date = null)
    {
        $this
            ->setDate($date);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \SabreSoap\StructType\Day
     */
    public function setDate($date = null)
    {
        $this->Date = $date;
        return $this;
    }
}
