<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerRefNumberType StructType
 * Meta information extracted from the WSDL
 * - documentation: A reference place holder used as a pointer to link back to the traveler.
 * @subpackage Structs
 */
class TravelerRefNumberType extends AbstractStructBase
{
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Reference place holder. | (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for TravelerRefNumberType
     * @uses TravelerRefNumberType::setRPH()
     * @param string $rPH
     */
    public function __construct($rPH = null)
    {
        $this
            ->setRPH($rPH);
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \SabreSoap\StructType\TravelerRefNumberType
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
}
