<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Veicolo StructType
 * Meta information extracted from the WSDL
 * - documentation: Veicolo che ha commesso la violazione
 * @subpackage Structs
 */
class Veicolo extends AbstractStructBase
{
    /**
     * The targa
     * Meta information extracted from the WSDL
     * - documentation: Targa veicolo
     * - minOccurs: 0
     * @var string
     */
    public $targa;
    /**
     * The classe
     * Meta information extracted from the WSDL
     * - documentation: Classe veicolo: A/B/3/4/5
     * @var string
     */
    public $classe;
    /**
     * The cod_nazione
     * Meta information extracted from the WSDL
     * - documentation: Codice nazione, se non presente si intende IT.
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9A-Z]{3}
     * @var string
     */
    public $cod_nazione;
    /**
     * Constructor method for Veicolo
     * @uses Veicolo::setTarga()
     * @uses Veicolo::setClasse()
     * @uses Veicolo::setCod_nazione()
     * @param string $targa
     * @param string $classe
     * @param string $cod_nazione
     */
    public function __construct($targa = null, $classe = null, $cod_nazione = null)
    {
        $this
            ->setTarga($targa)
            ->setClasse($classe)
            ->setCod_nazione($cod_nazione);
    }
    /**
     * Get targa value
     * @return string|null
     */
    public function getTarga()
    {
        return $this->targa;
    }
    /**
     * Set targa value
     * @param string $targa
     * @return \StructType\Veicolo
     */
    public function setTarga($targa = null)
    {
        // validation for constraint: string
        if (!is_null($targa) && !is_string($targa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targa, true), gettype($targa)), __LINE__);
        }
        $this->targa = $targa;
        return $this;
    }
    /**
     * Get classe value
     * @return string|null
     */
    public function getClasse()
    {
        return $this->classe;
    }
    /**
     * Set classe value
     * @param string $classe
     * @return \StructType\Veicolo
     */
    public function setClasse($classe = null)
    {
        // validation for constraint: string
        if (!is_null($classe) && !is_string($classe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classe, true), gettype($classe)), __LINE__);
        }
        $this->classe = $classe;
        return $this;
    }
    /**
     * Get cod_nazione value
     * @return string|null
     */
    public function getCod_nazione()
    {
        return $this->cod_nazione;
    }
    /**
     * Set cod_nazione value
     * @param string $cod_nazione
     * @return \StructType\Veicolo
     */
    public function setCod_nazione($cod_nazione = null)
    {
        // validation for constraint: string
        if (!is_null($cod_nazione) && !is_string($cod_nazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cod_nazione, true), gettype($cod_nazione)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{3})
        if (!is_null($cod_nazione) && !preg_match('/[0-9A-Z]{3}/', $cod_nazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{3}', var_export($cod_nazione, true)), __LINE__);
        }
        $this->cod_nazione = $cod_nazione;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Veicolo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
