<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferPaymentRequest StructType
 * @subpackage Structs
 */
class TransferPaymentRequest extends AbstractStructBase
{
    /**
     * The codSoc
     * @var int
     */
    public $codSoc;
    /**
     * The utente
     * @var string
     */
    public $utente;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The Root
     * Meta information extracted from the WSDL
     * - ref: pag_type:Root
     * @var \StructType\MainType
     */
    public $Root;
    /**
     * Constructor method for TransferPaymentRequest
     * @uses TransferPaymentRequest::setCodSoc()
     * @uses TransferPaymentRequest::setUtente()
     * @uses TransferPaymentRequest::setPassword()
     * @uses TransferPaymentRequest::setRoot()
     * @param int $codSoc
     * @param string $utente
     * @param string $password
     * @param \StructType\MainType $root
     */
    public function __construct($codSoc = null, $utente = null, $password = null, \StructType\MainType $root = null)
    {
        $this
            ->setCodSoc($codSoc)
            ->setUtente($utente)
            ->setPassword($password)
            ->setRoot($root);
    }
    /**
     * Get codSoc value
     * @return int|null
     */
    public function getCodSoc()
    {
        return $this->codSoc;
    }
    /**
     * Set codSoc value
     * @param int $codSoc
     * @return \StructType\TransferPaymentRequest
     */
    public function setCodSoc($codSoc = null)
    {
        // validation for constraint: int
        if (!is_null($codSoc) && !(is_int($codSoc) || ctype_digit($codSoc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codSoc, true), gettype($codSoc)), __LINE__);
        }
        $this->codSoc = $codSoc;
        return $this;
    }
    /**
     * Get utente value
     * @return string|null
     */
    public function getUtente()
    {
        return $this->utente;
    }
    /**
     * Set utente value
     * @param string $utente
     * @return \StructType\TransferPaymentRequest
     */
    public function setUtente($utente = null)
    {
        // validation for constraint: string
        if (!is_null($utente) && !is_string($utente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utente, true), gettype($utente)), __LINE__);
        }
        $this->utente = $utente;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\TransferPaymentRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Root value
     * @return \StructType\MainType|null
     */
    public function getRoot()
    {
        return $this->Root;
    }
    /**
     * Set Root value
     * @param \StructType\MainType $root
     * @return \StructType\TransferPaymentRequest
     */
    public function setRoot(\StructType\MainType $root = null)
    {
        $this->Root = $root;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransferPaymentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
