<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Root StructType
 * Meta information extracted from the WSDL
 * - type: MainType
 * @subpackage Structs
 */
class Root extends AbstractStructBase
{
    /**
     * The RmppDati
     * @var \StructType\RmppDati
     */
    public $RmppDati;
    /**
     * The Totale
     * @var float
     */
    public $Totale;
    /**
     * The Esito
     * @var string
     */
    public $Esito;
    /**
     * The Utente
     * @var string
     */
    public $Utente;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The NumRec
     * @var int
     */
    public $NumRec;
    /**
     * The DataDiscount
     * @var \StructType\DataDiscount
     */
    public $DataDiscount;
    /**
     * Constructor method for Root
     * @uses Root::setRmppDati()
     * @uses Root::setTotale()
     * @uses Root::setEsito()
     * @uses Root::setUtente()
     * @uses Root::setPassword()
     * @uses Root::setNumRec()
     * @uses Root::setDataDiscount()
     * @param \StructType\RmppDati $rmppDati
     * @param float $totale
     * @param string $esito
     * @param string $utente
     * @param string $password
     * @param int $numRec
     * @param \StructType\DataDiscount $dataDiscount
     */
    public function __construct(\StructType\RmppDati $rmppDati = null, $totale = null, $esito = null, $utente = null, $password = null, $numRec = null, \StructType\DataDiscount $dataDiscount = null)
    {
        $this
            ->setRmppDati($rmppDati)
            ->setTotale($totale)
            ->setEsito($esito)
            ->setUtente($utente)
            ->setPassword($password)
            ->setNumRec($numRec)
            ->setDataDiscount($dataDiscount);
    }
    /**
     * Get RmppDati value
     * @return \StructType\RmppDati|null
     */
    public function getRmppDati()
    {
        return $this->RmppDati;
    }
    /**
     * Set RmppDati value
     * @param \StructType\RmppDati $rmppDati
     * @return \StructType\Root
     */
    public function setRmppDati(\StructType\RmppDati $rmppDati = null)
    {
        $this->RmppDati = $rmppDati;
        return $this;
    }
    /**
     * Get Totale value
     * @return float|null
     */
    public function getTotale()
    {
        return $this->Totale;
    }
    /**
     * Set Totale value
     * @param float $totale
     * @return \StructType\Root
     */
    public function setTotale($totale = null)
    {
        // validation for constraint: float
        if (!is_null($totale) && !(is_float($totale) || is_numeric($totale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totale, true), gettype($totale)), __LINE__);
        }
        $this->Totale = $totale;
        return $this;
    }
    /**
     * Get Esito value
     * @return string|null
     */
    public function getEsito()
    {
        return $this->Esito;
    }
    /**
     * Set Esito value
     * @param string $esito
     * @return \StructType\Root
     */
    public function setEsito($esito = null)
    {
        // validation for constraint: string
        if (!is_null($esito) && !is_string($esito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esito, true), gettype($esito)), __LINE__);
        }
        $this->Esito = $esito;
        return $this;
    }
    /**
     * Get Utente value
     * @return string|null
     */
    public function getUtente()
    {
        return $this->Utente;
    }
    /**
     * Set Utente value
     * @param string $utente
     * @return \StructType\Root
     */
    public function setUtente($utente = null)
    {
        // validation for constraint: string
        if (!is_null($utente) && !is_string($utente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utente, true), gettype($utente)), __LINE__);
        }
        $this->Utente = $utente;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Root
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get NumRec value
     * @return int|null
     */
    public function getNumRec()
    {
        return $this->NumRec;
    }
    /**
     * Set NumRec value
     * @param int $numRec
     * @return \StructType\Root
     */
    public function setNumRec($numRec = null)
    {
        // validation for constraint: int
        if (!is_null($numRec) && !(is_int($numRec) || ctype_digit($numRec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numRec, true), gettype($numRec)), __LINE__);
        }
        $this->NumRec = $numRec;
        return $this;
    }
    /**
     * Get DataDiscount value
     * @return \StructType\DataDiscount|null
     */
    public function getDataDiscount()
    {
        return $this->DataDiscount;
    }
    /**
     * Set DataDiscount value
     * @param \StructType\DataDiscount $dataDiscount
     * @return \StructType\Root
     */
    public function setDataDiscount(\StructType\DataDiscount $dataDiscount = null)
    {
        $this->DataDiscount = $dataDiscount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Root
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
