<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MainType StructType
 * @subpackage Structs
 */
class MainType extends AbstractStructBase
{
    /**
     * The RmppDati
     * @var \StructType\RmppDati
     */
    public $RmppDati;
    /**
     * The Esito
     * @var string
     */
    public $Esito;
    /**
     * The NumRec
     * @var int
     */
    public $NumRec;
    /**
     * Constructor method for MainType
     * @uses MainType::setRmppDati()
     * @uses MainType::setEsito()
     * @uses MainType::setNumRec()
     * @param \StructType\RmppDati $rmppDati
     * @param string $esito
     * @param int $numRec
     */
    public function __construct(\StructType\RmppDati $rmppDati = null, $esito = null, $numRec = null)
    {
        $this
            ->setRmppDati($rmppDati)
            ->setEsito($esito)
            ->setNumRec($numRec);
    }
    /**
     * Get RmppDati value
     * @return \StructType\RmppDati|null
     */
    public function getRmppDati()
    {
        return $this->RmppDati;
    }
    /**
     * Set RmppDati value
     * @param \StructType\RmppDati $rmppDati
     * @return \StructType\MainType
     */
    public function setRmppDati(\StructType\RmppDati $rmppDati = null)
    {
        $this->RmppDati = $rmppDati;
        return $this;
    }
    /**
     * Get Esito value
     * @return string|null
     */
    public function getEsito()
    {
        return $this->Esito;
    }
    /**
     * Set Esito value
     * @param string $esito
     * @return \StructType\MainType
     */
    public function setEsito($esito = null)
    {
        // validation for constraint: string
        if (!is_null($esito) && !is_string($esito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esito, true), gettype($esito)), __LINE__);
        }
        $this->Esito = $esito;
        return $this;
    }
    /**
     * Get NumRec value
     * @return int|null
     */
    public function getNumRec()
    {
        return $this->NumRec;
    }
    /**
     * Set NumRec value
     * @param int $numRec
     * @return \StructType\MainType
     */
    public function setNumRec($numRec = null)
    {
        // validation for constraint: int
        if (!is_null($numRec) && !(is_int($numRec) || ctype_digit($numRec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numRec, true), gettype($numRec)), __LINE__);
        }
        $this->NumRec = $numRec;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MainType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
