<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInfoByRmppRequest StructType
 * @subpackage Structs
 */
class GetInfoByRmppRequest extends AbstractStructBase
{
    /**
     * The codSoc
     * @var int
     */
    public $codSoc;
    /**
     * The utente
     * @var string
     */
    public $utente;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The numAna
     * @var int
     */
    public $numAna;
    /**
     * Constructor method for GetInfoByRmppRequest
     * @uses GetInfoByRmppRequest::setCodSoc()
     * @uses GetInfoByRmppRequest::setUtente()
     * @uses GetInfoByRmppRequest::setPassword()
     * @uses GetInfoByRmppRequest::setNumAna()
     * @param int $codSoc
     * @param string $utente
     * @param string $password
     * @param int $numAna
     */
    public function __construct($codSoc = null, $utente = null, $password = null, $numAna = null)
    {
        $this
            ->setCodSoc($codSoc)
            ->setUtente($utente)
            ->setPassword($password)
            ->setNumAna($numAna);
    }
    /**
     * Get codSoc value
     * @return int|null
     */
    public function getCodSoc()
    {
        return $this->codSoc;
    }
    /**
     * Set codSoc value
     * @param int $codSoc
     * @return \StructType\GetInfoByRmppRequest
     */
    public function setCodSoc($codSoc = null)
    {
        // validation for constraint: int
        if (!is_null($codSoc) && !(is_int($codSoc) || ctype_digit($codSoc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codSoc, true), gettype($codSoc)), __LINE__);
        }
        $this->codSoc = $codSoc;
        return $this;
    }
    /**
     * Get utente value
     * @return string|null
     */
    public function getUtente()
    {
        return $this->utente;
    }
    /**
     * Set utente value
     * @param string $utente
     * @return \StructType\GetInfoByRmppRequest
     */
    public function setUtente($utente = null)
    {
        // validation for constraint: string
        if (!is_null($utente) && !is_string($utente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utente, true), gettype($utente)), __LINE__);
        }
        $this->utente = $utente;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetInfoByRmppRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get numAna value
     * @return int|null
     */
    public function getNumAna()
    {
        return $this->numAna;
    }
    /**
     * Set numAna value
     * @param int $numAna
     * @return \StructType\GetInfoByRmppRequest
     */
    public function setNumAna($numAna = null)
    {
        // validation for constraint: int
        if (!is_null($numAna) && !(is_int($numAna) || ctype_digit($numAna))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numAna, true), gettype($numAna)), __LINE__);
        }
        $this->numAna = $numAna;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInfoByRmppRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
