<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInfoByPidSolRequest StructType
 * @subpackage Structs
 */
class GetInfoByPidSolRequest extends AbstractStructBase
{
    /**
     * The codSoc
     * @var int
     */
    public $codSoc;
    /**
     * The utente
     * @var string
     */
    public $utente;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The numSol
     * @var int
     */
    public $numSol;
    /**
     * Constructor method for GetInfoByPidSolRequest
     * @uses GetInfoByPidSolRequest::setCodSoc()
     * @uses GetInfoByPidSolRequest::setUtente()
     * @uses GetInfoByPidSolRequest::setPassword()
     * @uses GetInfoByPidSolRequest::setNumSol()
     * @param int $codSoc
     * @param string $utente
     * @param string $password
     * @param int $numSol
     */
    public function __construct($codSoc = null, $utente = null, $password = null, $numSol = null)
    {
        $this
            ->setCodSoc($codSoc)
            ->setUtente($utente)
            ->setPassword($password)
            ->setNumSol($numSol);
    }
    /**
     * Get codSoc value
     * @return int|null
     */
    public function getCodSoc()
    {
        return $this->codSoc;
    }
    /**
     * Set codSoc value
     * @param int $codSoc
     * @return \StructType\GetInfoByPidSolRequest
     */
    public function setCodSoc($codSoc = null)
    {
        // validation for constraint: int
        if (!is_null($codSoc) && !(is_int($codSoc) || ctype_digit($codSoc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codSoc, true), gettype($codSoc)), __LINE__);
        }
        $this->codSoc = $codSoc;
        return $this;
    }
    /**
     * Get utente value
     * @return string|null
     */
    public function getUtente()
    {
        return $this->utente;
    }
    /**
     * Set utente value
     * @param string $utente
     * @return \StructType\GetInfoByPidSolRequest
     */
    public function setUtente($utente = null)
    {
        // validation for constraint: string
        if (!is_null($utente) && !is_string($utente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utente, true), gettype($utente)), __LINE__);
        }
        $this->utente = $utente;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetInfoByPidSolRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get numSol value
     * @return int|null
     */
    public function getNumSol()
    {
        return $this->numSol;
    }
    /**
     * Set numSol value
     * @param int $numSol
     * @return \StructType\GetInfoByPidSolRequest
     */
    public function setNumSol($numSol = null)
    {
        // validation for constraint: int
        if (!is_null($numSol) && !(is_int($numSol) || ctype_digit($numSol))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numSol, true), gettype($numSol)), __LINE__);
        }
        $this->numSol = $numSol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInfoByPidSolRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
