<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInfoByCodCnrRequest StructType
 * @subpackage Structs
 */
class GetInfoByCodCnrRequest extends AbstractStructBase
{
    /**
     * The CodCnr
     * @var int
     */
    public $CodCnr;
    /**
     * The codSoc
     * @var int
     */
    public $codSoc;
    /**
     * The utente
     * @var string
     */
    public $utente;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * Constructor method for GetInfoByCodCnrRequest
     * @uses GetInfoByCodCnrRequest::setCodCnr()
     * @uses GetInfoByCodCnrRequest::setCodSoc()
     * @uses GetInfoByCodCnrRequest::setUtente()
     * @uses GetInfoByCodCnrRequest::setPassword()
     * @param int $codCnr
     * @param int $codSoc
     * @param string $utente
     * @param string $password
     */
    public function __construct($codCnr = null, $codSoc = null, $utente = null, $password = null)
    {
        $this
            ->setCodCnr($codCnr)
            ->setCodSoc($codSoc)
            ->setUtente($utente)
            ->setPassword($password);
    }
    /**
     * Get CodCnr value
     * @return int|null
     */
    public function getCodCnr()
    {
        return $this->CodCnr;
    }
    /**
     * Set CodCnr value
     * @param int $codCnr
     * @return \StructType\GetInfoByCodCnrRequest
     */
    public function setCodCnr($codCnr = null)
    {
        // validation for constraint: int
        if (!is_null($codCnr) && !(is_int($codCnr) || ctype_digit($codCnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codCnr, true), gettype($codCnr)), __LINE__);
        }
        $this->CodCnr = $codCnr;
        return $this;
    }
    /**
     * Get codSoc value
     * @return int|null
     */
    public function getCodSoc()
    {
        return $this->codSoc;
    }
    /**
     * Set codSoc value
     * @param int $codSoc
     * @return \StructType\GetInfoByCodCnrRequest
     */
    public function setCodSoc($codSoc = null)
    {
        // validation for constraint: int
        if (!is_null($codSoc) && !(is_int($codSoc) || ctype_digit($codSoc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codSoc, true), gettype($codSoc)), __LINE__);
        }
        $this->codSoc = $codSoc;
        return $this;
    }
    /**
     * Get utente value
     * @return string|null
     */
    public function getUtente()
    {
        return $this->utente;
    }
    /**
     * Set utente value
     * @param string $utente
     * @return \StructType\GetInfoByCodCnrRequest
     */
    public function setUtente($utente = null)
    {
        // validation for constraint: string
        if (!is_null($utente) && !is_string($utente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utente, true), gettype($utente)), __LINE__);
        }
        $this->utente = $utente;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetInfoByCodCnrRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInfoByCodCnrRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
