<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dati_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Dati sconti pedaggio | Dati mancato pagamento pedaggio
 * @subpackage Structs
 */
class Dati_Type extends AbstractStructBase
{
    /**
     * The cod_soc
     * Meta information extracted from the WSDL
     * - documentation: Codice concessionaria che richiede i dati.
     * @var string
     */
    public $cod_soc;
    /**
     * The num_sol
     * Meta information extracted from the WSDL
     * - documentation: Numero sollecito in cui e' incluso il rmpp | Numero sollecito
     * - minOccurs: 0
     * @var string
     */
    public $num_sol;
    /**
     * The num_mpp
     * Meta information extracted from the WSDL
     * - documentation: Numero rapporto mancato pagamento pedaggio (rmpp)
     * @var string
     */
    public $num_mpp;
    /**
     * The importo_pagato
     * Meta information extracted from the WSDL
     * - documentation: Importo pagato comprensivo sempre di due decimali, moltiplicato per 100
     * @var float
     */
    public $importo_pagato;
    /**
     * The cod_transazione
     * Meta information extracted from the WSDL
     * - documentation: Codice transazione bancaria
     * @var string
     */
    public $cod_transazione;
    /**
     * The data_pagamento
     * Meta information extracted from the WSDL
     * - documentation: data pagamento (formato: dd/mm/yyyy)
     * @var string
     */
    public $data_pagamento;
    /**
     * The data_transito
     * Meta information extracted from the WSDL
     * - documentation: Data transito (formato dd/mm/yyyy hh24:mi:ss)
     * @var string
     */
    public $data_transito;
    /**
     * The stazione_uscita
     * Meta information extracted from the WSDL
     * - documentation: Stazione di uscita
     * @var string
     */
    public $stazione_uscita;
    /**
     * The stazione_entrata
     * Meta information extracted from the WSDL
     * - documentation: Stazione di entrata
     * - minOccurs: 0
     * @var string
     */
    public $stazione_entrata;
    /**
     * The importo_pedaggio
     * Meta information extracted from the WSDL
     * - documentation: Importo pedaggio non corrisposto comprensivo sempre di due decimali, moltiplicato per 100
     * @var float
     */
    public $importo_pedaggio;
    /**
     * The importo_acconto
     * Meta information extracted from the WSDL
     * - documentation: Acconto gia' pagato comprensivo sempre di due decimali, moltiplicato per 100
     * @var float
     */
    public $importo_acconto;
    /**
     * The importo_spese
     * Meta information extracted from the WSDL
     * - documentation: Importo spese comprensivo sempre di due decimali, moltiplicato per 100
     * @var float
     */
    public $importo_spese;
    /**
     * The importo_totale
     * Meta information extracted from the WSDL
     * - documentation: Importo totale dovuto calcolato come pedaggio + spese - acconto; comprensivo sempre di due decimali, moltiplicato per 100
     * @var float
     */
    public $importo_totale;
    /**
     * The veicolo
     * @var \StructType\Veicolo
     */
    public $veicolo;
    /**
     * The cod_cnr
     * Meta information extracted from the WSDL
     * - documentation: Codice Contratto
     * @var int
     */
    public $cod_cnr;
    /**
     * The cog
     * Meta information extracted from the WSDL
     * - documentation: Cognome
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $cog;
    /**
     * The nom
     * Meta information extracted from the WSDL
     * - documentation: nome
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $nom;
    /**
     * The ragSoc
     * Meta information extracted from the WSDL
     * - documentation: ragione sociale
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $ragSoc;
    /**
     * The rapLeg
     * Meta information extracted from the WSDL
     * - documentation: rappresentante legale
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $rapLeg;
    /**
     * The ind
     * Meta information extracted from the WSDL
     * - documentation: indirizzo
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $ind;
    /**
     * The cit
     * Meta information extracted from the WSDL
     * - documentation: città
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $cit;
    /**
     * The prv
     * Meta information extracted from the WSDL
     * - documentation: provincia
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $prv;
    /**
     * The cap
     * Meta information extracted from the WSDL
     * - documentation: cap
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $cap;
    /**
     * The numTel
     * Meta information extracted from the WSDL
     * - documentation: numero di Telefono
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $numTel;
    /**
     * The eml
     * Meta information extracted from the WSDL
     * - documentation: email
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $eml;
    /**
     * The cod_fis
     * Meta information extracted from the WSDL
     * - documentation: codice fiscale
     * - base: xs:string
     * - maxLength: 16
     * @var string
     */
    public $cod_fis;
    /**
     * The p_iva
     * Meta information extracted from the WSDL
     * - documentation: codice fiscale
     * - base: xs:string
     * - maxLength: 11
     * @var string
     */
    public $p_iva;
    /**
     * Constructor method for Dati_Type
     * @uses Dati_Type::setCod_soc()
     * @uses Dati_Type::setNum_sol()
     * @uses Dati_Type::setNum_mpp()
     * @uses Dati_Type::setImporto_pagato()
     * @uses Dati_Type::setCod_transazione()
     * @uses Dati_Type::setData_pagamento()
     * @uses Dati_Type::setData_transito()
     * @uses Dati_Type::setStazione_uscita()
     * @uses Dati_Type::setStazione_entrata()
     * @uses Dati_Type::setImporto_pedaggio()
     * @uses Dati_Type::setImporto_acconto()
     * @uses Dati_Type::setImporto_spese()
     * @uses Dati_Type::setImporto_totale()
     * @uses Dati_Type::setVeicolo()
     * @uses Dati_Type::setCod_cnr()
     * @uses Dati_Type::setCog()
     * @uses Dati_Type::setNom()
     * @uses Dati_Type::setRagSoc()
     * @uses Dati_Type::setRapLeg()
     * @uses Dati_Type::setInd()
     * @uses Dati_Type::setCit()
     * @uses Dati_Type::setPrv()
     * @uses Dati_Type::setCap()
     * @uses Dati_Type::setNumTel()
     * @uses Dati_Type::setEml()
     * @uses Dati_Type::setCod_fis()
     * @uses Dati_Type::setP_iva()
     * @param string $cod_soc
     * @param string $num_sol
     * @param string $num_mpp
     * @param float $importo_pagato
     * @param string $cod_transazione
     * @param string $data_pagamento
     * @param string $data_transito
     * @param string $stazione_uscita
     * @param string $stazione_entrata
     * @param float $importo_pedaggio
     * @param float $importo_acconto
     * @param float $importo_spese
     * @param float $importo_totale
     * @param \StructType\Veicolo $veicolo
     * @param int $cod_cnr
     * @param string $cog
     * @param string $nom
     * @param string $ragSoc
     * @param string $rapLeg
     * @param string $ind
     * @param string $cit
     * @param string $prv
     * @param string $cap
     * @param string $numTel
     * @param string $eml
     * @param string $cod_fis
     * @param string $p_iva
     */
    public function __construct($cod_soc = null, $num_sol = null, $num_mpp = null, $importo_pagato = null, $cod_transazione = null, $data_pagamento = null, $data_transito = null, $stazione_uscita = null, $stazione_entrata = null, $importo_pedaggio = null, $importo_acconto = null, $importo_spese = null, $importo_totale = null, \StructType\Veicolo $veicolo = null, $cod_cnr = null, $cog = null, $nom = null, $ragSoc = null, $rapLeg = null, $ind = null, $cit = null, $prv = null, $cap = null, $numTel = null, $eml = null, $cod_fis = null, $p_iva = null)
    {
        $this
            ->setCod_soc($cod_soc)
            ->setNum_sol($num_sol)
            ->setNum_mpp($num_mpp)
            ->setImporto_pagato($importo_pagato)
            ->setCod_transazione($cod_transazione)
            ->setData_pagamento($data_pagamento)
            ->setData_transito($data_transito)
            ->setStazione_uscita($stazione_uscita)
            ->setStazione_entrata($stazione_entrata)
            ->setImporto_pedaggio($importo_pedaggio)
            ->setImporto_acconto($importo_acconto)
            ->setImporto_spese($importo_spese)
            ->setImporto_totale($importo_totale)
            ->setVeicolo($veicolo)
            ->setCod_cnr($cod_cnr)
            ->setCog($cog)
            ->setNom($nom)
            ->setRagSoc($ragSoc)
            ->setRapLeg($rapLeg)
            ->setInd($ind)
            ->setCit($cit)
            ->setPrv($prv)
            ->setCap($cap)
            ->setNumTel($numTel)
            ->setEml($eml)
            ->setCod_fis($cod_fis)
            ->setP_iva($p_iva);
    }
    /**
     * Get cod_soc value
     * @return string|null
     */
    public function getCod_soc()
    {
        return $this->cod_soc;
    }
    /**
     * Set cod_soc value
     * @param string $cod_soc
     * @return \StructType\Dati_Type
     */
    public function setCod_soc($cod_soc = null)
    {
        // validation for constraint: string
        if (!is_null($cod_soc) && !is_string($cod_soc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cod_soc, true), gettype($cod_soc)), __LINE__);
        }
        $this->cod_soc = $cod_soc;
        return $this;
    }
    /**
     * Get num_sol value
     * @return string|null
     */
    public function getNum_sol()
    {
        return $this->num_sol;
    }
    /**
     * Set num_sol value
     * @param string $num_sol
     * @return \StructType\Dati_Type
     */
    public function setNum_sol($num_sol = null)
    {
        // validation for constraint: string
        if (!is_null($num_sol) && !is_string($num_sol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($num_sol, true), gettype($num_sol)), __LINE__);
        }
        $this->num_sol = $num_sol;
        return $this;
    }
    /**
     * Get num_mpp value
     * @return string|null
     */
    public function getNum_mpp()
    {
        return $this->num_mpp;
    }
    /**
     * Set num_mpp value
     * @param string $num_mpp
     * @return \StructType\Dati_Type
     */
    public function setNum_mpp($num_mpp = null)
    {
        // validation for constraint: string
        if (!is_null($num_mpp) && !is_string($num_mpp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($num_mpp, true), gettype($num_mpp)), __LINE__);
        }
        $this->num_mpp = $num_mpp;
        return $this;
    }
    /**
     * Get importo_pagato value
     * @return float|null
     */
    public function getImporto_pagato()
    {
        return $this->importo_pagato;
    }
    /**
     * Set importo_pagato value
     * @param float $importo_pagato
     * @return \StructType\Dati_Type
     */
    public function setImporto_pagato($importo_pagato = null)
    {
        // validation for constraint: float
        if (!is_null($importo_pagato) && !(is_float($importo_pagato) || is_numeric($importo_pagato))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importo_pagato, true), gettype($importo_pagato)), __LINE__);
        }
        $this->importo_pagato = $importo_pagato;
        return $this;
    }
    /**
     * Get cod_transazione value
     * @return string|null
     */
    public function getCod_transazione()
    {
        return $this->cod_transazione;
    }
    /**
     * Set cod_transazione value
     * @param string $cod_transazione
     * @return \StructType\Dati_Type
     */
    public function setCod_transazione($cod_transazione = null)
    {
        // validation for constraint: string
        if (!is_null($cod_transazione) && !is_string($cod_transazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cod_transazione, true), gettype($cod_transazione)), __LINE__);
        }
        $this->cod_transazione = $cod_transazione;
        return $this;
    }
    /**
     * Get data_pagamento value
     * @return string|null
     */
    public function getData_pagamento()
    {
        return $this->data_pagamento;
    }
    /**
     * Set data_pagamento value
     * @param string $data_pagamento
     * @return \StructType\Dati_Type
     */
    public function setData_pagamento($data_pagamento = null)
    {
        // validation for constraint: string
        if (!is_null($data_pagamento) && !is_string($data_pagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data_pagamento, true), gettype($data_pagamento)), __LINE__);
        }
        $this->data_pagamento = $data_pagamento;
        return $this;
    }
    /**
     * Get data_transito value
     * @return string|null
     */
    public function getData_transito()
    {
        return $this->data_transito;
    }
    /**
     * Set data_transito value
     * @param string $data_transito
     * @return \StructType\Dati_Type
     */
    public function setData_transito($data_transito = null)
    {
        // validation for constraint: string
        if (!is_null($data_transito) && !is_string($data_transito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data_transito, true), gettype($data_transito)), __LINE__);
        }
        $this->data_transito = $data_transito;
        return $this;
    }
    /**
     * Get stazione_uscita value
     * @return string|null
     */
    public function getStazione_uscita()
    {
        return $this->stazione_uscita;
    }
    /**
     * Set stazione_uscita value
     * @param string $stazione_uscita
     * @return \StructType\Dati_Type
     */
    public function setStazione_uscita($stazione_uscita = null)
    {
        // validation for constraint: string
        if (!is_null($stazione_uscita) && !is_string($stazione_uscita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stazione_uscita, true), gettype($stazione_uscita)), __LINE__);
        }
        $this->stazione_uscita = $stazione_uscita;
        return $this;
    }
    /**
     * Get stazione_entrata value
     * @return string|null
     */
    public function getStazione_entrata()
    {
        return $this->stazione_entrata;
    }
    /**
     * Set stazione_entrata value
     * @param string $stazione_entrata
     * @return \StructType\Dati_Type
     */
    public function setStazione_entrata($stazione_entrata = null)
    {
        // validation for constraint: string
        if (!is_null($stazione_entrata) && !is_string($stazione_entrata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stazione_entrata, true), gettype($stazione_entrata)), __LINE__);
        }
        $this->stazione_entrata = $stazione_entrata;
        return $this;
    }
    /**
     * Get importo_pedaggio value
     * @return float|null
     */
    public function getImporto_pedaggio()
    {
        return $this->importo_pedaggio;
    }
    /**
     * Set importo_pedaggio value
     * @param float $importo_pedaggio
     * @return \StructType\Dati_Type
     */
    public function setImporto_pedaggio($importo_pedaggio = null)
    {
        // validation for constraint: float
        if (!is_null($importo_pedaggio) && !(is_float($importo_pedaggio) || is_numeric($importo_pedaggio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importo_pedaggio, true), gettype($importo_pedaggio)), __LINE__);
        }
        $this->importo_pedaggio = $importo_pedaggio;
        return $this;
    }
    /**
     * Get importo_acconto value
     * @return float|null
     */
    public function getImporto_acconto()
    {
        return $this->importo_acconto;
    }
    /**
     * Set importo_acconto value
     * @param float $importo_acconto
     * @return \StructType\Dati_Type
     */
    public function setImporto_acconto($importo_acconto = null)
    {
        // validation for constraint: float
        if (!is_null($importo_acconto) && !(is_float($importo_acconto) || is_numeric($importo_acconto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importo_acconto, true), gettype($importo_acconto)), __LINE__);
        }
        $this->importo_acconto = $importo_acconto;
        return $this;
    }
    /**
     * Get importo_spese value
     * @return float|null
     */
    public function getImporto_spese()
    {
        return $this->importo_spese;
    }
    /**
     * Set importo_spese value
     * @param float $importo_spese
     * @return \StructType\Dati_Type
     */
    public function setImporto_spese($importo_spese = null)
    {
        // validation for constraint: float
        if (!is_null($importo_spese) && !(is_float($importo_spese) || is_numeric($importo_spese))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importo_spese, true), gettype($importo_spese)), __LINE__);
        }
        $this->importo_spese = $importo_spese;
        return $this;
    }
    /**
     * Get importo_totale value
     * @return float|null
     */
    public function getImporto_totale()
    {
        return $this->importo_totale;
    }
    /**
     * Set importo_totale value
     * @param float $importo_totale
     * @return \StructType\Dati_Type
     */
    public function setImporto_totale($importo_totale = null)
    {
        // validation for constraint: float
        if (!is_null($importo_totale) && !(is_float($importo_totale) || is_numeric($importo_totale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importo_totale, true), gettype($importo_totale)), __LINE__);
        }
        $this->importo_totale = $importo_totale;
        return $this;
    }
    /**
     * Get veicolo value
     * @return \StructType\Veicolo|null
     */
    public function getVeicolo()
    {
        return $this->veicolo;
    }
    /**
     * Set veicolo value
     * @param \StructType\Veicolo $veicolo
     * @return \StructType\Dati_Type
     */
    public function setVeicolo(\StructType\Veicolo $veicolo = null)
    {
        $this->veicolo = $veicolo;
        return $this;
    }
    /**
     * Get cod_cnr value
     * @return int|null
     */
    public function getCod_cnr()
    {
        return $this->cod_cnr;
    }
    /**
     * Set cod_cnr value
     * @param int $cod_cnr
     * @return \StructType\Dati_Type
     */
    public function setCod_cnr($cod_cnr = null)
    {
        // validation for constraint: int
        if (!is_null($cod_cnr) && !(is_int($cod_cnr) || ctype_digit($cod_cnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cod_cnr, true), gettype($cod_cnr)), __LINE__);
        }
        $this->cod_cnr = $cod_cnr;
        return $this;
    }
    /**
     * Get cog value
     * @return string|null
     */
    public function getCog()
    {
        return $this->cog;
    }
    /**
     * Set cog value
     * @param string $cog
     * @return \StructType\Dati_Type
     */
    public function setCog($cog = null)
    {
        // validation for constraint: string
        if (!is_null($cog) && !is_string($cog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cog, true), gettype($cog)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($cog) && mb_strlen($cog) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($cog)), __LINE__);
        }
        $this->cog = $cog;
        return $this;
    }
    /**
     * Get nom value
     * @return string|null
     */
    public function getNom()
    {
        return $this->nom;
    }
    /**
     * Set nom value
     * @param string $nom
     * @return \StructType\Dati_Type
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($nom) && mb_strlen($nom) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($nom)), __LINE__);
        }
        $this->nom = $nom;
        return $this;
    }
    /**
     * Get ragSoc value
     * @return string|null
     */
    public function getRagSoc()
    {
        return $this->ragSoc;
    }
    /**
     * Set ragSoc value
     * @param string $ragSoc
     * @return \StructType\Dati_Type
     */
    public function setRagSoc($ragSoc = null)
    {
        // validation for constraint: string
        if (!is_null($ragSoc) && !is_string($ragSoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ragSoc, true), gettype($ragSoc)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($ragSoc) && mb_strlen($ragSoc) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($ragSoc)), __LINE__);
        }
        $this->ragSoc = $ragSoc;
        return $this;
    }
    /**
     * Get rapLeg value
     * @return string|null
     */
    public function getRapLeg()
    {
        return $this->rapLeg;
    }
    /**
     * Set rapLeg value
     * @param string $rapLeg
     * @return \StructType\Dati_Type
     */
    public function setRapLeg($rapLeg = null)
    {
        // validation for constraint: string
        if (!is_null($rapLeg) && !is_string($rapLeg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rapLeg, true), gettype($rapLeg)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($rapLeg) && mb_strlen($rapLeg) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($rapLeg)), __LINE__);
        }
        $this->rapLeg = $rapLeg;
        return $this;
    }
    /**
     * Get ind value
     * @return string|null
     */
    public function getInd()
    {
        return $this->ind;
    }
    /**
     * Set ind value
     * @param string $ind
     * @return \StructType\Dati_Type
     */
    public function setInd($ind = null)
    {
        // validation for constraint: string
        if (!is_null($ind) && !is_string($ind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ind, true), gettype($ind)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($ind) && mb_strlen($ind) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($ind)), __LINE__);
        }
        $this->ind = $ind;
        return $this;
    }
    /**
     * Get cit value
     * @return string|null
     */
    public function getCit()
    {
        return $this->cit;
    }
    /**
     * Set cit value
     * @param string $cit
     * @return \StructType\Dati_Type
     */
    public function setCit($cit = null)
    {
        // validation for constraint: string
        if (!is_null($cit) && !is_string($cit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cit, true), gettype($cit)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($cit) && mb_strlen($cit) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($cit)), __LINE__);
        }
        $this->cit = $cit;
        return $this;
    }
    /**
     * Get prv value
     * @return string|null
     */
    public function getPrv()
    {
        return $this->prv;
    }
    /**
     * Set prv value
     * @param string $prv
     * @return \StructType\Dati_Type
     */
    public function setPrv($prv = null)
    {
        // validation for constraint: string
        if (!is_null($prv) && !is_string($prv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prv, true), gettype($prv)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($prv) && mb_strlen($prv) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($prv)), __LINE__);
        }
        $this->prv = $prv;
        return $this;
    }
    /**
     * Get cap value
     * @return string|null
     */
    public function getCap()
    {
        return $this->cap;
    }
    /**
     * Set cap value
     * @param string $cap
     * @return \StructType\Dati_Type
     */
    public function setCap($cap = null)
    {
        // validation for constraint: string
        if (!is_null($cap) && !is_string($cap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cap, true), gettype($cap)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($cap) && mb_strlen($cap) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($cap)), __LINE__);
        }
        $this->cap = $cap;
        return $this;
    }
    /**
     * Get numTel value
     * @return string|null
     */
    public function getNumTel()
    {
        return $this->numTel;
    }
    /**
     * Set numTel value
     * @param string $numTel
     * @return \StructType\Dati_Type
     */
    public function setNumTel($numTel = null)
    {
        // validation for constraint: string
        if (!is_null($numTel) && !is_string($numTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numTel, true), gettype($numTel)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($numTel) && mb_strlen($numTel) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($numTel)), __LINE__);
        }
        $this->numTel = $numTel;
        return $this;
    }
    /**
     * Get eml value
     * @return string|null
     */
    public function getEml()
    {
        return $this->eml;
    }
    /**
     * Set eml value
     * @param string $eml
     * @return \StructType\Dati_Type
     */
    public function setEml($eml = null)
    {
        // validation for constraint: string
        if (!is_null($eml) && !is_string($eml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eml, true), gettype($eml)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($eml) && mb_strlen($eml) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($eml)), __LINE__);
        }
        $this->eml = $eml;
        return $this;
    }
    /**
     * Get cod_fis value
     * @return string|null
     */
    public function getCod_fis()
    {
        return $this->cod_fis;
    }
    /**
     * Set cod_fis value
     * @param string $cod_fis
     * @return \StructType\Dati_Type
     */
    public function setCod_fis($cod_fis = null)
    {
        // validation for constraint: string
        if (!is_null($cod_fis) && !is_string($cod_fis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cod_fis, true), gettype($cod_fis)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($cod_fis) && mb_strlen($cod_fis) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($cod_fis)), __LINE__);
        }
        $this->cod_fis = $cod_fis;
        return $this;
    }
    /**
     * Get p_iva value
     * @return string|null
     */
    public function getP_iva()
    {
        return $this->p_iva;
    }
    /**
     * Set p_iva value
     * @param string $p_iva
     * @return \StructType\Dati_Type
     */
    public function setP_iva($p_iva = null)
    {
        // validation for constraint: string
        if (!is_null($p_iva) && !is_string($p_iva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($p_iva, true), gettype($p_iva)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($p_iva) && mb_strlen($p_iva) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($p_iva)), __LINE__);
        }
        $this->p_iva = $p_iva;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Dati_Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
