<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transfer ServiceType
 * @subpackage Services
 */
class Transfer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TransferUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferUserRequest $transferUserRequest
     * @return \StructType\TransferUserResponse|bool
     */
    public function TransferUser(\StructType\TransferUserRequest $transferUserRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferUser($transferUserRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferPaymentRequest $transferPaymentRequest
     * @return \StructType\TransferPaymentResponse|bool
     */
    public function TransferPayment(\StructType\TransferPaymentRequest $transferPaymentRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferPayment($transferPaymentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TransferPaymentResponse|\StructType\TransferUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
