<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetInfoByRmpp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInfoByRmppRequest $getInfoByRmppRequest
     * @return \StructType\GetInfoByRmppResponse|bool
     */
    public function GetInfoByRmpp(\StructType\GetInfoByRmppRequest $getInfoByRmppRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInfoByRmpp($getInfoByRmppRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInfoByPidSol
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInfoByPidSolRequest $getInfoByPidSolRequest
     * @return \StructType\GetInfoByPidSolResponse|bool
     */
    public function GetInfoByPidSol(\StructType\GetInfoByPidSolRequest $getInfoByPidSolRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInfoByPidSol($getInfoByPidSolRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInfoByCodCnr
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInfoByCodCnrRequest $getInfoByCodCnrRequest
     * @return \StructType\GetInfoByCodCnrResponse|bool
     */
    public function GetInfoByCodCnr(\StructType\GetInfoByCodCnrRequest $getInfoByCodCnrRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInfoByCodCnr($getInfoByCodCnrRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetInfoByCodCnrResponse|\StructType\GetInfoByPidSolResponse|\StructType\GetInfoByRmppResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
