<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDeliveryCost StructType
 * @subpackage Structs
 */
class GetDeliveryCost extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: s1:address
     * @var \StructType\Address
     */
    public $address;
    /**
     * The orderWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $orderWeight;
    /**
     * The orderWidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $orderWidth;
    /**
     * The orderHeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $orderHeight;
    /**
     * The orderLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $orderLength;
    /**
     * The deliveryPlaceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $deliveryPlaceId;
    /**
     * The sourcePlaceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $sourcePlaceId;
    /**
     * The accessKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accessKey;
    /**
     * Constructor method for GetDeliveryCost
     * @uses GetDeliveryCost::setAddress()
     * @uses GetDeliveryCost::setOrderWeight()
     * @uses GetDeliveryCost::setOrderWidth()
     * @uses GetDeliveryCost::setOrderHeight()
     * @uses GetDeliveryCost::setOrderLength()
     * @uses GetDeliveryCost::setDeliveryPlaceId()
     * @uses GetDeliveryCost::setSourcePlaceId()
     * @uses GetDeliveryCost::setAccessKey()
     * @param \StructType\Address $address
     * @param float $orderWeight
     * @param float $orderWidth
     * @param float $orderHeight
     * @param float $orderLength
     * @param int $deliveryPlaceId
     * @param int $sourcePlaceId
     * @param string $accessKey
     */
    public function __construct(\StructType\Address $address = null, $orderWeight = null, $orderWidth = null, $orderHeight = null, $orderLength = null, $deliveryPlaceId = null, $sourcePlaceId = null, $accessKey = null)
    {
        $this
            ->setAddress($address)
            ->setOrderWeight($orderWeight)
            ->setOrderWidth($orderWidth)
            ->setOrderHeight($orderHeight)
            ->setOrderLength($orderLength)
            ->setDeliveryPlaceId($deliveryPlaceId)
            ->setSourcePlaceId($sourcePlaceId)
            ->setAccessKey($accessKey);
    }
    /**
     * Get address value
     * @return \StructType\Address
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\Address $address
     * @return \StructType\GetDeliveryCost
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get orderWeight value
     * @return float
     */
    public function getOrderWeight()
    {
        return $this->orderWeight;
    }
    /**
     * Set orderWeight value
     * @param float $orderWeight
     * @return \StructType\GetDeliveryCost
     */
    public function setOrderWeight($orderWeight = null)
    {
        // validation for constraint: float
        if (!is_null($orderWeight) && !(is_float($orderWeight) || is_numeric($orderWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderWeight, true), gettype($orderWeight)), __LINE__);
        }
        $this->orderWeight = $orderWeight;
        return $this;
    }
    /**
     * Get orderWidth value
     * @return float
     */
    public function getOrderWidth()
    {
        return $this->orderWidth;
    }
    /**
     * Set orderWidth value
     * @param float $orderWidth
     * @return \StructType\GetDeliveryCost
     */
    public function setOrderWidth($orderWidth = null)
    {
        // validation for constraint: float
        if (!is_null($orderWidth) && !(is_float($orderWidth) || is_numeric($orderWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderWidth, true), gettype($orderWidth)), __LINE__);
        }
        $this->orderWidth = $orderWidth;
        return $this;
    }
    /**
     * Get orderHeight value
     * @return float
     */
    public function getOrderHeight()
    {
        return $this->orderHeight;
    }
    /**
     * Set orderHeight value
     * @param float $orderHeight
     * @return \StructType\GetDeliveryCost
     */
    public function setOrderHeight($orderHeight = null)
    {
        // validation for constraint: float
        if (!is_null($orderHeight) && !(is_float($orderHeight) || is_numeric($orderHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderHeight, true), gettype($orderHeight)), __LINE__);
        }
        $this->orderHeight = $orderHeight;
        return $this;
    }
    /**
     * Get orderLength value
     * @return float
     */
    public function getOrderLength()
    {
        return $this->orderLength;
    }
    /**
     * Set orderLength value
     * @param float $orderLength
     * @return \StructType\GetDeliveryCost
     */
    public function setOrderLength($orderLength = null)
    {
        // validation for constraint: float
        if (!is_null($orderLength) && !(is_float($orderLength) || is_numeric($orderLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderLength, true), gettype($orderLength)), __LINE__);
        }
        $this->orderLength = $orderLength;
        return $this;
    }
    /**
     * Get deliveryPlaceId value
     * @return int
     */
    public function getDeliveryPlaceId()
    {
        return $this->deliveryPlaceId;
    }
    /**
     * Set deliveryPlaceId value
     * @param int $deliveryPlaceId
     * @return \StructType\GetDeliveryCost
     */
    public function setDeliveryPlaceId($deliveryPlaceId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryPlaceId) && !(is_int($deliveryPlaceId) || ctype_digit($deliveryPlaceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryPlaceId, true), gettype($deliveryPlaceId)), __LINE__);
        }
        $this->deliveryPlaceId = $deliveryPlaceId;
        return $this;
    }
    /**
     * Get sourcePlaceId value
     * @return int
     */
    public function getSourcePlaceId()
    {
        return $this->sourcePlaceId;
    }
    /**
     * Set sourcePlaceId value
     * @param int $sourcePlaceId
     * @return \StructType\GetDeliveryCost
     */
    public function setSourcePlaceId($sourcePlaceId = null)
    {
        // validation for constraint: int
        if (!is_null($sourcePlaceId) && !(is_int($sourcePlaceId) || ctype_digit($sourcePlaceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourcePlaceId, true), gettype($sourcePlaceId)), __LINE__);
        }
        $this->sourcePlaceId = $sourcePlaceId;
        return $this;
    }
    /**
     * Get accessKey value
     * @return string|null
     */
    public function getAccessKey()
    {
        return $this->accessKey;
    }
    /**
     * Set accessKey value
     * @param string $accessKey
     * @return \StructType\GetDeliveryCost
     */
    public function setAccessKey($accessKey = null)
    {
        // validation for constraint: string
        if (!is_null($accessKey) && !is_string($accessKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessKey, true), gettype($accessKey)), __LINE__);
        }
        $this->accessKey = $accessKey;
        return $this;
    }
}
