<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrdersStatus ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrdersStatus extends AbstractStructArrayBase
{
    /**
     * The OrdersStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrdersStatus[]
     */
    public $OrdersStatus;
    /**
     * Constructor method for ArrayOfOrdersStatus
     * @uses ArrayOfOrdersStatus::setOrdersStatus()
     * @param \StructType\OrdersStatus[] $ordersStatus
     */
    public function __construct(array $ordersStatus = array())
    {
        $this
            ->setOrdersStatus($ordersStatus);
    }
    /**
     * Get OrdersStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrdersStatus[]|null
     */
    public function getOrdersStatus()
    {
        return isset($this->OrdersStatus) ? $this->OrdersStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrdersStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrdersStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrdersStatusForArrayConstraintsFromSetOrdersStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrdersStatusOrdersStatusItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrdersStatusOrdersStatusItem instanceof \StructType\OrdersStatus) {
                $invalidValues[] = is_object($arrayOfOrdersStatusOrdersStatusItem) ? get_class($arrayOfOrdersStatusOrdersStatusItem) : sprintf('%s(%s)', gettype($arrayOfOrdersStatusOrdersStatusItem), var_export($arrayOfOrdersStatusOrdersStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrdersStatus property can only contain items of type \StructType\OrdersStatus, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrdersStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrdersStatus[] $ordersStatus
     * @return \ArrayType\ArrayOfOrdersStatus
     */
    public function setOrdersStatus(array $ordersStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($ordersStatusArrayErrorMessage = self::validateOrdersStatusForArrayConstraintsFromSetOrdersStatus($ordersStatus))) {
            throw new \InvalidArgumentException($ordersStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($ordersStatus) || (is_array($ordersStatus) && empty($ordersStatus))) {
            unset($this->OrdersStatus);
        } else {
            $this->OrdersStatus = $ordersStatus;
        }
        return $this;
    }
    /**
     * Add item to OrdersStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\OrdersStatus $item
     * @return \ArrayType\ArrayOfOrdersStatus
     */
    public function addToOrdersStatus(\StructType\OrdersStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrdersStatus) {
            throw new \InvalidArgumentException(sprintf('The OrdersStatus property can only contain items of type \StructType\OrdersStatus, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrdersStatus[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrdersStatus|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrdersStatus|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrdersStatus|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrdersStatus|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrdersStatus|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrdersStatus
     */
    public function getAttributeName()
    {
        return 'OrdersStatus';
    }
}
