<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderReceipt ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderReceipt extends AbstractStructArrayBase
{
    /**
     * The OrderReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderReceipt[]
     */
    public $OrderReceipt;
    /**
     * Constructor method for ArrayOfOrderReceipt
     * @uses ArrayOfOrderReceipt::setOrderReceipt()
     * @param \StructType\OrderReceipt[] $orderReceipt
     */
    public function __construct(array $orderReceipt = array())
    {
        $this
            ->setOrderReceipt($orderReceipt);
    }
    /**
     * Get OrderReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderReceipt[]|null
     */
    public function getOrderReceipt()
    {
        return isset($this->OrderReceipt) ? $this->OrderReceipt : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderReceipt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderReceipt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderReceiptForArrayConstraintsFromSetOrderReceipt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderReceiptOrderReceiptItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderReceiptOrderReceiptItem instanceof \StructType\OrderReceipt) {
                $invalidValues[] = is_object($arrayOfOrderReceiptOrderReceiptItem) ? get_class($arrayOfOrderReceiptOrderReceiptItem) : sprintf('%s(%s)', gettype($arrayOfOrderReceiptOrderReceiptItem), var_export($arrayOfOrderReceiptOrderReceiptItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderReceipt property can only contain items of type \StructType\OrderReceipt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderReceipt[] $orderReceipt
     * @return \ArrayType\ArrayOfOrderReceipt
     */
    public function setOrderReceipt(array $orderReceipt = array())
    {
        // validation for constraint: array
        if ('' !== ($orderReceiptArrayErrorMessage = self::validateOrderReceiptForArrayConstraintsFromSetOrderReceipt($orderReceipt))) {
            throw new \InvalidArgumentException($orderReceiptArrayErrorMessage, __LINE__);
        }
        if (is_null($orderReceipt) || (is_array($orderReceipt) && empty($orderReceipt))) {
            unset($this->OrderReceipt);
        } else {
            $this->OrderReceipt = $orderReceipt;
        }
        return $this;
    }
    /**
     * Add item to OrderReceipt value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderReceipt $item
     * @return \ArrayType\ArrayOfOrderReceipt
     */
    public function addToOrderReceipt(\StructType\OrderReceipt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderReceipt) {
            throw new \InvalidArgumentException(sprintf('The OrderReceipt property can only contain items of type \StructType\OrderReceipt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderReceipt[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderReceipt|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderReceipt|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderReceipt|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderReceipt|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderReceipt|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderReceipt
     */
    public function getAttributeName()
    {
        return 'OrderReceipt';
    }
}
