<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersStatus StructType
 * @subpackage Structs
 */
class OrdersStatus extends AbstractStructBase
{
    /**
     * The RouteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RouteId;
    /**
     * The RoutingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RoutingDate;
    /**
     * The DeliveryPlaceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryPlaceID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Order;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * Constructor method for OrdersStatus
     * @uses OrdersStatus::setRouteId()
     * @uses OrdersStatus::setRoutingDate()
     * @uses OrdersStatus::setDeliveryPlaceID()
     * @uses OrdersStatus::setOrder()
     * @uses OrdersStatus::setStatus()
     * @param int $routeId
     * @param string $routingDate
     * @param int $deliveryPlaceID
     * @param int $order
     * @param int $status
     */
    public function __construct($routeId = null, $routingDate = null, $deliveryPlaceID = null, $order = null, $status = null)
    {
        $this
            ->setRouteId($routeId)
            ->setRoutingDate($routingDate)
            ->setDeliveryPlaceID($deliveryPlaceID)
            ->setOrder($order)
            ->setStatus($status);
    }
    /**
     * Get RouteId value
     * @return int
     */
    public function getRouteId()
    {
        return $this->RouteId;
    }
    /**
     * Set RouteId value
     * @param int $routeId
     * @return \StructType\OrdersStatus
     */
    public function setRouteId($routeId = null)
    {
        // validation for constraint: int
        if (!is_null($routeId) && !(is_int($routeId) || ctype_digit($routeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routeId, true), gettype($routeId)), __LINE__);
        }
        $this->RouteId = $routeId;
        return $this;
    }
    /**
     * Get RoutingDate value
     * @return string
     */
    public function getRoutingDate()
    {
        return $this->RoutingDate;
    }
    /**
     * Set RoutingDate value
     * @param string $routingDate
     * @return \StructType\OrdersStatus
     */
    public function setRoutingDate($routingDate = null)
    {
        // validation for constraint: string
        if (!is_null($routingDate) && !is_string($routingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingDate, true), gettype($routingDate)), __LINE__);
        }
        $this->RoutingDate = $routingDate;
        return $this;
    }
    /**
     * Get DeliveryPlaceID value
     * @return int
     */
    public function getDeliveryPlaceID()
    {
        return $this->DeliveryPlaceID;
    }
    /**
     * Set DeliveryPlaceID value
     * @param int $deliveryPlaceID
     * @return \StructType\OrdersStatus
     */
    public function setDeliveryPlaceID($deliveryPlaceID = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryPlaceID) && !(is_int($deliveryPlaceID) || ctype_digit($deliveryPlaceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryPlaceID, true), gettype($deliveryPlaceID)), __LINE__);
        }
        $this->DeliveryPlaceID = $deliveryPlaceID;
        return $this;
    }
    /**
     * Get Order value
     * @return int
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\OrdersStatus
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\OrdersStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
