<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePickupPointResponse StructType
 * @subpackage Structs
 */
class UpdatePickupPointResponse extends Response
{
    /**
     * The PickupPointId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PickupPointId;
    /**
     * The UpdatePickupPointResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UpdatePickupPointResponse
     */
    public $UpdatePickupPointResult;
    /**
     * Constructor method for UpdatePickupPointResponse
     * @uses UpdatePickupPointResponse::setPickupPointId()
     * @uses UpdatePickupPointResponse::setUpdatePickupPointResult()
     * @param int $pickupPointId
     * @param \StructType\UpdatePickupPointResponse $updatePickupPointResult
     */
    public function __construct($pickupPointId = null, \StructType\UpdatePickupPointResponse $updatePickupPointResult = null)
    {
        $this
            ->setPickupPointId($pickupPointId)
            ->setUpdatePickupPointResult($updatePickupPointResult);
    }
    /**
     * Get PickupPointId value
     * @return int
     */
    public function getPickupPointId()
    {
        return $this->PickupPointId;
    }
    /**
     * Set PickupPointId value
     * @param int $pickupPointId
     * @return \StructType\UpdatePickupPointResponse
     */
    public function setPickupPointId($pickupPointId = null)
    {
        // validation for constraint: int
        if (!is_null($pickupPointId) && !(is_int($pickupPointId) || ctype_digit($pickupPointId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pickupPointId, true), gettype($pickupPointId)), __LINE__);
        }
        $this->PickupPointId = $pickupPointId;
        return $this;
    }
    /**
     * Get UpdatePickupPointResult value
     * @return \StructType\UpdatePickupPointResponse|null
     */
    public function getUpdatePickupPointResult()
    {
        return $this->UpdatePickupPointResult;
    }
    /**
     * Set UpdatePickupPointResult value
     * @param \StructType\UpdatePickupPointResponse $updatePickupPointResult
     * @return \StructType\UpdatePickupPointResponse
     */
    public function setUpdatePickupPointResult(\StructType\UpdatePickupPointResponse $updatePickupPointResult = null)
    {
        $this->UpdatePickupPointResult = $updatePickupPointResult;
        return $this;
    }
}
