<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateOrderContactDetails StructType
 * @subpackage Structs
 */
class UpdateOrderContactDetails extends AbstractStructBase
{
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderId;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: s1:user
     * @var \StructType\User
     */
    public $user;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: s1:address
     * @var \StructType\Address
     */
    public $address;
    /**
     * The deliveryPlaceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $deliveryPlaceId;
    /**
     * The accessKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accessKey;
    /**
     * Constructor method for UpdateOrderContactDetails
     * @uses UpdateOrderContactDetails::setOrderId()
     * @uses UpdateOrderContactDetails::setUser()
     * @uses UpdateOrderContactDetails::setAddress()
     * @uses UpdateOrderContactDetails::setDeliveryPlaceId()
     * @uses UpdateOrderContactDetails::setAccessKey()
     * @param int $orderId
     * @param \StructType\User $user
     * @param \StructType\Address $address
     * @param int $deliveryPlaceId
     * @param string $accessKey
     */
    public function __construct($orderId = null, \StructType\User $user = null, \StructType\Address $address = null, $deliveryPlaceId = null, $accessKey = null)
    {
        $this
            ->setOrderId($orderId)
            ->setUser($user)
            ->setAddress($address)
            ->setDeliveryPlaceId($deliveryPlaceId)
            ->setAccessKey($accessKey);
    }
    /**
     * Get orderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \StructType\UpdateOrderContactDetails
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get user value
     * @return \StructType\User
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param \StructType\User $user
     * @return \StructType\UpdateOrderContactDetails
     */
    public function setUser(\StructType\User $user = null)
    {
        $this->user = $user;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\Address
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\Address $address
     * @return \StructType\UpdateOrderContactDetails
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get deliveryPlaceId value
     * @return int
     */
    public function getDeliveryPlaceId()
    {
        return $this->deliveryPlaceId;
    }
    /**
     * Set deliveryPlaceId value
     * @param int $deliveryPlaceId
     * @return \StructType\UpdateOrderContactDetails
     */
    public function setDeliveryPlaceId($deliveryPlaceId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryPlaceId) && !(is_int($deliveryPlaceId) || ctype_digit($deliveryPlaceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryPlaceId, true), gettype($deliveryPlaceId)), __LINE__);
        }
        $this->deliveryPlaceId = $deliveryPlaceId;
        return $this;
    }
    /**
     * Get accessKey value
     * @return string|null
     */
    public function getAccessKey()
    {
        return $this->accessKey;
    }
    /**
     * Set accessKey value
     * @param string $accessKey
     * @return \StructType\UpdateOrderContactDetails
     */
    public function setAccessKey($accessKey = null)
    {
        // validation for constraint: string
        if (!is_null($accessKey) && !is_string($accessKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessKey, true), gettype($accessKey)), __LINE__);
        }
        $this->accessKey = $accessKey;
        return $this;
    }
}
