<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceBarcode StructType
 * @subpackage Structs
 */
class PieceBarcode extends AbstractStructBase
{
    /**
     * The piece
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $piece;
    /**
     * The barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $barcode;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The printFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $printFormat;
    /**
     * The labelContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $labelContent;
    /**
     * Constructor method for PieceBarcode
     * @uses PieceBarcode::setPiece()
     * @uses PieceBarcode::setBarcode()
     * @uses PieceBarcode::setType()
     * @uses PieceBarcode::setPrintFormat()
     * @uses PieceBarcode::setLabelContent()
     * @param int $piece
     * @param string $barcode
     * @param string $type
     * @param int $printFormat
     * @param string $labelContent
     */
    public function __construct($piece = null, $barcode = null, $type = null, $printFormat = null, $labelContent = null)
    {
        $this
            ->setPiece($piece)
            ->setBarcode($barcode)
            ->setType($type)
            ->setPrintFormat($printFormat)
            ->setLabelContent($labelContent);
    }
    /**
     * Get piece value
     * @return int
     */
    public function getPiece()
    {
        return $this->piece;
    }
    /**
     * Set piece value
     * @param int $piece
     * @return \StructType\PieceBarcode
     */
    public function setPiece($piece = null)
    {
        // validation for constraint: int
        if (!is_null($piece) && !(is_int($piece) || ctype_digit($piece))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($piece, true), gettype($piece)), __LINE__);
        }
        $this->piece = $piece;
        return $this;
    }
    /**
     * Get barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \StructType\PieceBarcode
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\PieceBarcode
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get printFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintFormat()
    {
        return isset($this->printFormat) ? $this->printFormat : null;
    }
    /**
     * Set printFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printFormat
     * @return \StructType\PieceBarcode
     */
    public function setPrintFormat($printFormat = null)
    {
        // validation for constraint: int
        if (!is_null($printFormat) && !(is_int($printFormat) || ctype_digit($printFormat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printFormat, true), gettype($printFormat)), __LINE__);
        }
        if (is_null($printFormat) || (is_array($printFormat) && empty($printFormat))) {
            unset($this->printFormat);
        } else {
            $this->printFormat = $printFormat;
        }
        return $this;
    }
    /**
     * Get labelContent value
     * @return string|null
     */
    public function getLabelContent()
    {
        return $this->labelContent;
    }
    /**
     * Set labelContent value
     * @param string $labelContent
     * @return \StructType\PieceBarcode
     */
    public function setLabelContent($labelContent = null)
    {
        // validation for constraint: string
        if (!is_null($labelContent) && !is_string($labelContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelContent, true), gettype($labelContent)), __LINE__);
        }
        $this->labelContent = $labelContent;
        return $this;
    }
}
