<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pickingTask StructType
 * @subpackage Structs
 */
class PickingTask extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $date;
    /**
     * The settingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $settingId;
    /**
     * The regionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regionId;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The pickingItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PickingItem[]
     */
    public $pickingItems;
    /**
     * Constructor method for pickingTask
     * @uses PickingTask::setDate()
     * @uses PickingTask::setSettingId()
     * @uses PickingTask::setRegionId()
     * @uses PickingTask::setNumber()
     * @uses PickingTask::setPickingItems()
     * @param string $date
     * @param int $settingId
     * @param int $regionId
     * @param string $number
     * @param \StructType\PickingItem[] $pickingItems
     */
    public function __construct($date = null, $settingId = null, $regionId = null, $number = null, array $pickingItems = array())
    {
        $this
            ->setDate($date)
            ->setSettingId($settingId)
            ->setRegionId($regionId)
            ->setNumber($number)
            ->setPickingItems($pickingItems);
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\PickingTask
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get settingId value
     * @return int
     */
    public function getSettingId()
    {
        return $this->settingId;
    }
    /**
     * Set settingId value
     * @param int $settingId
     * @return \StructType\PickingTask
     */
    public function setSettingId($settingId = null)
    {
        // validation for constraint: int
        if (!is_null($settingId) && !(is_int($settingId) || ctype_digit($settingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingId, true), gettype($settingId)), __LINE__);
        }
        $this->settingId = $settingId;
        return $this;
    }
    /**
     * Get regionId value
     * @return int
     */
    public function getRegionId()
    {
        return $this->regionId;
    }
    /**
     * Set regionId value
     * @param int $regionId
     * @return \StructType\PickingTask
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: int
        if (!is_null($regionId) && !(is_int($regionId) || ctype_digit($regionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regionId, true), gettype($regionId)), __LINE__);
        }
        $this->regionId = $regionId;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\PickingTask
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get pickingItems value
     * @return \StructType\PickingItem[]|null
     */
    public function getPickingItems()
    {
        return $this->pickingItems;
    }
    /**
     * This method is responsible for validating the values passed to the setPickingItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickingItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePickingItemsForArrayConstraintsFromSetPickingItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pickingTaskPickingItemsItem) {
            // validation for constraint: itemType
            if (!$pickingTaskPickingItemsItem instanceof \StructType\PickingItem) {
                $invalidValues[] = is_object($pickingTaskPickingItemsItem) ? get_class($pickingTaskPickingItemsItem) : sprintf('%s(%s)', gettype($pickingTaskPickingItemsItem), var_export($pickingTaskPickingItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pickingItems property can only contain items of type \StructType\PickingItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pickingItems value
     * @throws \InvalidArgumentException
     * @param \StructType\PickingItem[] $pickingItems
     * @return \StructType\PickingTask
     */
    public function setPickingItems(array $pickingItems = array())
    {
        // validation for constraint: array
        if ('' !== ($pickingItemsArrayErrorMessage = self::validatePickingItemsForArrayConstraintsFromSetPickingItems($pickingItems))) {
            throw new \InvalidArgumentException($pickingItemsArrayErrorMessage, __LINE__);
        }
        $this->pickingItems = $pickingItems;
        return $this;
    }
    /**
     * Add item to pickingItems value
     * @throws \InvalidArgumentException
     * @param \StructType\PickingItem $item
     * @return \StructType\PickingTask
     */
    public function addToPickingItems(\StructType\PickingItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PickingItem) {
            throw new \InvalidArgumentException(sprintf('The pickingItems property can only contain items of type \StructType\PickingItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pickingItems[] = $item;
        return $this;
    }
}
