<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryData StructType
 * @subpackage Structs
 */
class DeliveryData extends AbstractStructBase
{
    /**
     * The DeliveryCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeliveryCost;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryDate;
    /**
     * Constructor method for DeliveryData
     * @uses DeliveryData::setDeliveryCost()
     * @uses DeliveryData::setDeliveryDate()
     * @param float $deliveryCost
     * @param string $deliveryDate
     */
    public function __construct($deliveryCost = null, $deliveryDate = null)
    {
        $this
            ->setDeliveryCost($deliveryCost)
            ->setDeliveryDate($deliveryDate);
    }
    /**
     * Get DeliveryCost value
     * @return float
     */
    public function getDeliveryCost()
    {
        return $this->DeliveryCost;
    }
    /**
     * Set DeliveryCost value
     * @param float $deliveryCost
     * @return \StructType\DeliveryData
     */
    public function setDeliveryCost($deliveryCost = null)
    {
        // validation for constraint: float
        if (!is_null($deliveryCost) && !(is_float($deliveryCost) || is_numeric($deliveryCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deliveryCost, true), gettype($deliveryCost)), __LINE__);
        }
        $this->DeliveryCost = $deliveryCost;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\DeliveryData
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
}
