<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceCost ArrayType
 * @subpackage Arrays
 */
class ArrayOfServiceCost extends AbstractStructArrayBase
{
    /**
     * The ServiceCost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceCost[]
     */
    public $ServiceCost;
    /**
     * Constructor method for ArrayOfServiceCost
     * @uses ArrayOfServiceCost::setServiceCost()
     * @param \StructType\ServiceCost[] $serviceCost
     */
    public function __construct(array $serviceCost = array())
    {
        $this
            ->setServiceCost($serviceCost);
    }
    /**
     * Get ServiceCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceCost[]|null
     */
    public function getServiceCost()
    {
        return isset($this->ServiceCost) ? $this->ServiceCost : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceCost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceCost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceCostForArrayConstraintsFromSetServiceCost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfServiceCostServiceCostItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceCostServiceCostItem instanceof \StructType\ServiceCost) {
                $invalidValues[] = is_object($arrayOfServiceCostServiceCostItem) ? get_class($arrayOfServiceCostServiceCostItem) : sprintf('%s(%s)', gettype($arrayOfServiceCostServiceCostItem), var_export($arrayOfServiceCostServiceCostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceCost property can only contain items of type \StructType\ServiceCost, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCost[] $serviceCost
     * @return \ArrayType\ArrayOfServiceCost
     */
    public function setServiceCost(array $serviceCost = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceCostArrayErrorMessage = self::validateServiceCostForArrayConstraintsFromSetServiceCost($serviceCost))) {
            throw new \InvalidArgumentException($serviceCostArrayErrorMessage, __LINE__);
        }
        if (is_null($serviceCost) || (is_array($serviceCost) && empty($serviceCost))) {
            unset($this->ServiceCost);
        } else {
            $this->ServiceCost = $serviceCost;
        }
        return $this;
    }
    /**
     * Add item to ServiceCost value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCost $item
     * @return \ArrayType\ArrayOfServiceCost
     */
    public function addToServiceCost(\StructType\ServiceCost $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceCost) {
            throw new \InvalidArgumentException(sprintf('The ServiceCost property can only contain items of type \StructType\ServiceCost, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceCost[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceCost|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceCost|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceCost|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceCost|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceCost|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceCost
     */
    public function getAttributeName()
    {
        return 'ServiceCost';
    }
}
